/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

#ifndef DEF_PACPUS_PERIODIC_WORKER_H
#define DEF_PACPUS_PERIODIC_WORKER_H

// Includes, pacpus.
#include <PacpusTools/AsyncWorkerBase.h>

class QTimer;

namespace pacpus
{
  /** PeriodicWorker
   * @brief A simple base class for periodic worker.
   *
   * @example
   *    class MyWorker
   *      : public PeriodicWorkder
   *    {
   *      public:
   *        void doWork() { std::cout << "Hey, I'm working!" << std::endl; }
   *    };
   *
   *    // Do its work every second.
   *    MyWorker worker;
   *    worker.startWork(1000);
   */
  class PeriodicWorker
    : public AsyncWorkerBase
  {
    Q_OBJECT
    public:
      /// Ctor of PeriodicWorker.
      PeriodicWorker();
      
      /// Dtor of PeriodicWorker.
      virtual ~PeriodicWorker();
      
      /** Start the periodic worker.
       * @param msec Period in mseconds.
       */
      void startWork(int msec);
      
      /** Stop the periodic worker, but do not delete it. */
      void stopWork();
      
    public slots:
      /** Do the work.
       * This method need to be implemented in the subclasses, it will be called
       * each time the timer has reached its period.
       */
      virtual void doWork() = 0;
      
    private:
      QTimer* mHeartbeat;
  };
}

#endif // DEF_PACPUS_PERIODIC_WORKER_H
