/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

#ifndef DEF_PACPUS_POSIXSHMEM_H
#define DEF_PACPUS_POSIXSHMEM_H

#include <QSharedMemory>
#include <QSystemSemaphore>

#include <Pacpus/PacpusTools/ShMemBase.h>

class PosixShMem
        : public ShMemBase
{
public:
    PosixShMem(const char * name, int size);
    virtual ~PosixShMem();

    virtual void *read();
    virtual void write(void *data, int size, unsigned long offset = 0);
    virtual bool wait(unsigned long timeout = 0);
    virtual void lockMemory();
    virtual void unlockMemory();

private:
    QSystemSemaphore * event_;
    QSharedMemory * memory_;
};

#endif // DEF_PACPUS_POSIXSHMEM_H
