/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

#ifndef DEF_PACPUS_COMPONENTFACTORYBASE_H
#define DEF_PACPUS_COMPONENTFACTORYBASE_H

#include <Pacpus/kernel/pacpus.h>

class QString;

namespace pacpus {

class ComponentManager;
class ComponentBase;

/** ComponentFactoryBase
 * @brief Provide an abstract class to the template ComponentFactory.
 */
class PACPUSLIB_API ComponentFactoryBase
{
    friend class ComponentManager;

public:
	ComponentFactoryBase();
	virtual ~ComponentFactoryBase();

protected:
    virtual ComponentBase * instantiateComponent(const QString & name) = 0;
    void addFactory(ComponentFactoryBase * addr, const QString & type);
    void addComponent(const QString & name);

private:
    ComponentManager * mgr_;
};

} // namespace pacpus

#endif
