/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

#ifndef DEF_PACPUS_DBTPLYENGINESTATECHART_H
#define DEF_PACPUS_DBTPLYENGINESTATECHART_H

#include <QString>

#include <Pacpus/DbitePlayer/DbitePlayerConfig.h>

namespace pacpus {

class DbtPlyEngine;

////////////////////////////////////////////////////////////////////////////////
class DBITE_PLAYER_API DbtPlyEngineState
{
public:
    virtual ~DbtPlyEngineState();

    virtual void play(DbtPlyEngine & engine);
    virtual void pause(DbtPlyEngine & engine);
    virtual void stop(DbtPlyEngine & engine);

    virtual void speedUp(DbtPlyEngine & engine);
    virtual void speedDown(DbtPlyEngine & engine);

    virtual bool isPlaying();

    virtual QString toString() const = 0;

protected:
    DbtPlyEngineState();
};

////////////////////////////////////////////////////////////////////////////////
class DBITE_PLAYER_API PlayingState
        : public DbtPlyEngineState
{
public:
    virtual void pause(DbtPlyEngine & engine);
    virtual void stop(DbtPlyEngine & engine);

    virtual bool isPlaying();

    virtual QString toString() const;
    static DbtPlyEngineState * getInstance();

private:
    PlayingState();
    static PlayingState mInstance;
};

////////////////////////////////////////////////////////////////////////////////
class DBITE_PLAYER_API PausedState
        : public DbtPlyEngineState
{
public:
    virtual void play(DbtPlyEngine & engine);
    virtual void stop(DbtPlyEngine & engine);

    virtual QString toString() const;
    static DbtPlyEngineState * getInstance();

private:
    PausedState();
    static PausedState mInstance;
};

////////////////////////////////////////////////////////////////////////////////
class DBITE_PLAYER_API StoppedState
        : public DbtPlyEngineState
{
public:
    virtual void play(DbtPlyEngine & engine);

    virtual QString toString() const;
    static DbtPlyEngineState * getInstance();

private:
    StoppedState();
    static StoppedState mInstance;
};

} // namespace pacpus

#endif // DEF_PACPUS_DBTPLYENGINESTATECHART_H
