/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

#ifndef DEF_HDFILE_HEADER_T_H
#define DEF_HDFILE_HEADER_T_H

#include "kernel/cstdint.h"
#include "kernel/road_time.h"

#define HEADER_SIGNATURE_LENGTH 4
#define VERSION_NUMBER	2

#pragma pack(push,4)
struct hdfile_header_t
{
    typedef  int8_t SignatureT;
    typedef int32_t DataTypeT;
    typedef int32_t VersionT;
    typedef int32_t DataSizeT;
    typedef int32_t DataOffsetT;
    // FIXME: file size should be 64-bit long to support large (>2GB) files
    typedef int32_t FileSizeT;
    typedef int32_t RecordCountT;

    static const DataSizeT kVariableRecordSize = -1;

    SignatureT      Signature[HEADER_SIGNATURE_LENGTH];
    DataTypeT       Type;           /* IMAGE, CAN, UNKNOWN, etc. */
    VersionT        VersionNumber;
    DataOffsetT     DataOffset;     /* starting of the data */
    DataSizeT       DataSize;       /* number of byte for data */
    FileSizeT       FileSize;       /* current size of the file */
    road_time_t     TimeMin, TimeMax;
    RecordCountT    NbRecords;      /* number of records */
};
#pragma pack(pop)

#endif // DEF_HDFILE_HEADER_T_H
