/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

#ifndef DEF_PACPUS_SHMEM_H
#define DEF_PACPUS_SHMEM_H

#ifdef WIN32
#   include "Win32ShMem.h"
#   define ShMemType Win32ShMem
#else
#   include "PosixShMem.h"
#   define ShMemType PosixShMem
#endif

namespace pacpus {

class ShMem
        : public ShMemType
{
public:
    ShMem(const char * name, int size)
        : ShMemType(name, size)
    {
    }

    ~ShMem()
    {
    }

protected:
private:
};

} // namespace pacpus

#endif // DEF_PACPUS_SHMEM_H
