/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

#ifndef DEF_PACPUS_SHMEMBASE_H
#define DEF_PACPUS_SHMEMBASE_H

class ShMemBase
{
public:
  ShMemBase()
  {
      /*printf("ShMemBase::ShMemBase() not implemented !\n");*/
  }

  virtual ~ShMemBase()
  {
      /*printf("ShMemBase::~ShMemBase() not implemented !\n");*/
  }

  // Use this method to get the data of the shared memory
  virtual void *read() = 0; 

  // Use this method to write data in shared memory
  virtual void write(void *data, int size, unsigned long offset = 0) = 0; 

  // Use this method to wait the incoming of new data
  // you can specify a timeout in ms to avoid infinite blocking or 0 (infinite)
  // return true if new data available before the timeout or else false
  virtual bool wait(unsigned long timeout = 0) = 0; 

  // To lock the access to the memory
  virtual void lockMemory() = 0; 

  // To unlock the access to the memory
  virtual void unlockMemory() = 0; 

#ifdef WIN32
  // Return the event handle under Windows 
  // ... under Linux ? 
  virtual void * getEventIdentifier() = 0; 
#endif 
  
protected:
  void * shMem_; 
	
private:
};

#endif // DEF_PACPUS_SHMEMBASE_H
