/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

#ifndef DEF_PACPUS_WIN32SHMEM_H
#define DEF_PACPUS_WIN32SHMEM_H

#include <Pacpus/PacpusTools/ShMemBase.h>

typedef void * HANDLE;

class Win32ShMem
        : public ShMemBase
{
public:
    Win32ShMem(const char * name, int size);
    ~Win32ShMem();

    virtual bool wait(unsigned long timeout = 0);
    virtual void * read();
    virtual void read(void * mem, int size);
    virtual void write(void * data, int size, unsigned long offset = 0);
    virtual void lockMemory();
    virtual void unlockMemory();
    virtual void * getEventIdentifier();

protected:  

private:
    HANDLE semaphore_;
    HANDLE shMemHandle_;
    HANDLE event_;
};

#endif // DEF_PACPUS_WIN32SHMEM_H
