/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

#include <Pacpus/kernel/ComponentFactoryBase.h>
#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/ComponentManager.h>
#include <Pacpus/kernel/Log.h>

#include <cassert>
#include <QString>

using namespace pacpus;

DECLARE_STATIC_LOGGER("pacpus.core.ComponentFactoryBase");

ComponentFactoryBase::ComponentFactoryBase()
{
    LOG_TRACE("constructor");

    // get the adress of the ComponentManager instance
    mgr_ = ComponentManager::getInstance();
}

ComponentFactoryBase::~ComponentFactoryBase()
{
    LOG_TRACE("destructor");
}

void ComponentFactoryBase::addFactory(ComponentFactoryBase * addr, const QString & type)
{
    LOG_DEBUG("addFactory(type="<< type << ")");

    assert(mgr_);
    if (!mgr_->registerComponentFactory(addr, type)) {
        /*
        // FIXME: delete in a secure manner (no double delete)
        delete addr;
        addr = NULL;
        */
    }
}

void ComponentFactoryBase::addComponent(const QString & name)
{
    LOG_DEBUG("addComponent(" << name << ")");

    // FIXME: instantiated component is never deleted!
    // who should do it? ComponentManager?
    ComponentBase * addr = instantiateComponent(name);
    assert(mgr_);
    if (!mgr_->registerComponent(addr, name)) {
        delete addr;
        addr = NULL;
    }
}
