/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/ComponentManager.h>
#include <Pacpus/kernel/Log.h>

using namespace pacpus;

DECLARE_STATIC_LOGGER("pacpus.core.ComponentBase");

ComponentBase::ComponentBase(const QString& name)
{
    LOG_TRACE("constructor");

    configuration_ = NOT_CONFIGURED;
    componentName = name;
    recording = true;
    THREAD_ALIVE = true;
    mIsActive = 0;
    componentState_ = ComponentBase::NOT_MONITORED;

    // we get a pointer on the instance of ComponentManager
    mgr = ComponentManager::getInstance();

    LOG_INFO("component " << componentName
             << " was created"
             );
}

ComponentBase::~ComponentBase()
{  
    LOG_TRACE("destructor");
}

int ComponentBase::startComponent()
{
    if (mIsActive == 0) {
        mIsActive = 1;
        startActivity();
        return 1;
    } else {
        return 0;
    }
}

int ComponentBase::stopComponent()
{
    if (mIsActive == 1) {
        mIsActive = 0;
        stopActivity();
        return 1;
    } else {
        return 0;
    }
}

void ComponentBase::setState(const COMPONENT_STATE state)
{
    if (state != componentState_) {
        componentState_ = state;
    }
}

// FIXME: this should be const.
ComponentBase::COMPONENT_STATE ComponentBase::getState()
{
    COMPONENT_STATE state = componentState_;
    if (ComponentBase::NOT_MONITORED != componentState_) {
        componentState_ = ComponentBase::MONITOR_NOK;
    }
    return state;
}

bool ComponentBase::isConfigured() const
{
    return CONFIGURED_OK == configuration_;
}
