/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

// Includes, pacpus.
#include <kernel/Log.h>
#include <PacpusTools/AsyncWorkerBase.h>

// Includes, qt.
#include <QThread>

using namespace pacpus;
DECLARE_STATIC_LOGGER("pamu.core.workers");

AsyncWorkerBase::AsyncWorkerBase()
  : active_(false)
  , stopping_(false)
{
}

AsyncWorkerBase::~AsyncWorkerBase()
{
}

void
AsyncWorkerBase::start()
{
  if (!isActive())
  {
    QThread* theThread = new QThread;

    // Executes the setup() method as soon as theThread is started
    connect(theThread, SIGNAL(started()), SLOT(doSetup()));

    // Executes the finish() method as soon as theThread 

    // Allows stopping requests to be handled withing the worker thread instead
    // of the thread that made the stop() call.
    connect(this, SIGNAL(stopped()), this, SLOT(doFinish()));

    // Guarantees theThread is terminated and deleted once the worker has 
    // stopped and is destroyed
    connect(this, SIGNAL(finished()), theThread, SLOT(quit()));
    connect(theThread, SIGNAL(finished()), theThread, SLOT(deleteLater()));
    
    active_ = true;
    this->moveToThread(theThread);
    theThread->start();
  }
}

void
AsyncWorkerBase::stop(bool autoDelete)
{
	if (isActive())
  {
    if (autoDelete)
    {
      // Guarantees deletion of this once all pending signals have been handled
      connect(this, SIGNAL(finished()), this, SLOT(deleteLater()));
    }
		stopping_ = true;
		emit stopped();
	}
  else
  {
    if (autoDelete)
      delete this;
  }
}

void AsyncWorkerBase::finish()
{
	if (isActive())
  {
    cleanup();
		emit finished();
		active_ = false;
	}
}

void AsyncWorkerBase::setup()
{
}

void AsyncWorkerBase::process()
{
}

void AsyncWorkerBase::cleanup()
{
}

void AsyncWorkerBase::doSetup()
{
  setup();
  process();
}

void AsyncWorkerBase::doFinish()
{ 
  finish();
}
