/*********************************************************************
// created:     2007/04/12 - 16:30
// filename:    main.cpp
//
// author:      Elie Al Alam & Gerald Dherbomez
//
// version:     $Id: main.cpp 1009 2012-08-01 19:03:32Z morasjul $
//
// purpose:     main file
//
// todo:        - barre de temps dans l'affichage graphique
//              - am�liorer l'affichage ; ic�ne, emplacement des boutons...
//              - ajouter r�pertoire racine des donn�es (fait) :
//              ajouter affichage de ce r�pertoire
//              - ajouter classe g�n�rique d'�change de donn�es vers
//              d'autres applications
//              - fen�tre de monitoring des composants : valable pour
//              toutes les applis bas�es sur PacpusLib
//              avec possibilit� de masquer cette partie
//              - faire une classe GraphViewer :
//              permet d'afficher un nombre ind�fini de courbes
//              offre des param�tres basiques : couleurs de la courbe,
//              types de points, reli�s ou pas
//              les courbes sont identifi�s par des noms
//              voir comment l'utilisateur peut interagir avec les courbes
//              par ex recuperer la valeur d'un point
//              - associer a chaque composant une fenetre en dock view,
//              affichagable ou pas defini dans le fichier de config
*********************************************************************/

#include <cassert>
#include <QApplication>

#include <Pacpus/DbitePlayer/DbtPlyEngine.h>
#include <Pacpus/DbitePlayer/DbtPlyTrigger.h>
#include <Pacpus/DbitePlayer/DbtPlyUserInterface.h>
#include <Pacpus/kernel/ComponentManager.h>
#include <Pacpus/kernel/ComponentFactory.h>
#include <Pacpus/kernel/Log.h>
#include <Pacpus/kernel/PacpusPluginInterface.h>

using namespace pacpus;
using namespace std;

DECLARE_STATIC_LOGGER("pacpus.core.DbitePlayer");

static const string kDefaultXmlConfigFilePath = "DbitePlayer.xml";

int main(int argc, char * argv[])
{
    QApplication app(argc, argv);
    ComponentManager * mgr = ComponentManager::getInstance();

    static ComponentFactory<DbtPlyEngine> factoryDbtPlyEngine("DbtPlyEngine");
    Q_UNUSED(factoryDbtPlyEngine);
    static ComponentFactory<DbtPlyTrigger> factoryDbtPlyTrigger("DbtPlyTrigger");
    Q_UNUSED(factoryDbtPlyTrigger);
    static ComponentFactory<DbtPlyUserInterface> factoryDbtPlyUserInterface("DbtPlyUserInterface");
    Q_UNUSED(factoryDbtPlyUserInterface);

    string configFilePath;
    if (argc > 1) {
        configFilePath = argv[1];
    } else {
        configFilePath = kDefaultXmlConfigFilePath;
        LOG_WARN("no XML config file specified. Using default: " << configFilePath);
    }
    LOG_INFO("loading file '" << configFilePath << "'");
    size_t componentCount = mgr->loadComponents(configFilePath.c_str());
    if (componentCount == 0) {
        LOG_FATAL("no components, exiting");
        return EXIT_FAILURE;
    }

    // start all the components (engine, trigger, user interface and the DBT file managers)
    mgr->start();
    // save application exit status
    int exitStatus = app.exec();
    // stop all components before exiting app
    mgr->stop();

    mgr->destroy();

    // return application exit status
    return exitStatus;
}
