/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

// Includes, pacpus.
#include <PacpusTools/PeriodicWorker.h>

// Includes, qt.
#include <QTimer>

using namespace pacpus;

PeriodicWorker::PeriodicWorker()
  : AsyncWorkerBase()
  , mHeartbeat(NULL)
{
  mHeartbeat = new QTimer(this);
}

PeriodicWorker::~PeriodicWorker()
{
}

void
PeriodicWorker::startWork(int msec)
{
  mHeartbeat->start(msec);
  connect(mHeartbeat, SIGNAL(timeout()), this, SLOT(doWork()));
  
  this->start();
}

void
PeriodicWorker::stopWork()
{
  disconnect(mHeartbeat, SIGNAL(timeout()), this, SLOT(doWork()));
}
