/*********************************************************************
//  created:    2008/2/28 - 16:47
//  filename:   CanFrame.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Abstract class
//
*********************************************************************/

#pragma once
#ifndef CANFRAMEBASE_H
#define CANFRAMEBASE_H

#include "../driver/CanDriverBase.h"

namespace pacpus {

class CanFrameBase
{
public:
  CanFrameBase(){}
  ~CanFrameBase(){}
  
  void setData(TimestampedCanFrame d) { d_ = d; }
  virtual void decode() = 0;
  virtual void * data() = 0; 
  virtual int size() = 0;
  void setRoadTime(road_time_t rdt) { d_.time = rdt; }
  void setTimeRange(road_timerange_t tmr) { d_.timerange = tmr; }
  road_time_t time(){ return d_.time;}
  road_timerange_t timerange(){ return d_.timerange;}

protected:
  TimestampedCanFrame d_;

private:
  
};

}

#endif // CANFRAMEBASE_H
