/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

#ifndef PACPUSMAINWINDOW_H
#define PACPUSMAINWINDOW_H

#include <qcheckbox.h>
#include <qdialog.h>
#include <qtimer.h>

#include <Pacpus/kernel/ComponentManager.h>
#include <Pacpus/kernel/XmlConfigFile.h>
#include "ui_pacpusmainwindow.h"

class QGroupBox;
class QVBoxLayout;

namespace pacpus {

/// Overloaded class of the QCheckBox in order to get the text
/// of the button when it is clicked.
class ComponentCheckBox
        : public QCheckBox
{ 
    Q_OBJECT

public:
    ComponentCheckBox(const QString & text, QWidget * parent, const char * /*name*/ = 0 )
        : QCheckBox(text, parent)
    {
        connect(this, SIGNAL(toggled(bool)),
                SLOT(change(bool)));
    }

    ~ComponentCheckBox()
    {
    }

public Q_SLOTS:
    void change(bool state)
    {
        if (state) {
            Q_EMIT activate(text());
        } else {
            Q_EMIT deactivate(text());
        }
    }

Q_SIGNALS:
    void activate(QString);
    void deactivate(QString);
};

////////////////////////////////////////////////////////////////////////////////
class PacpusMainWindow
        : public QDialog
        , public Ui::PacpusMainWindow
{
    Q_OBJECT

public:
    PacpusMainWindow(QWidget * parent = 0);
	~PacpusMainWindow();

public Q_SLOTS:
    void startAcquisition();
    void startComponent(QString component);

    void stopAcquisition();
    void stopComponent(QString component);

    void monitoring();

private:
    ComponentManager * componentManager_;

    QVBoxLayout * layoutBox_;
    QGroupBox * componentContainer_;
    QButtonGroup * componentGroup_;

    QTimer monitoringTimer_;

    bool continue_;
    unsigned short nbActiveComponent_;
};

} // namespace pacpus

#endif // PACPUSMAINWINDOW_H
