#################################################
#   ___________    ____ ______  __ __  _____    #
#   \____ \__  \ _/ ___\\____ \|  |  \/  ___/   #
#   |  |_> > __ \\  \___|  |_> >  |  /\___ \    #
#   |   __(____  /\___  >   __/|____//____  >   #
#   |__|       \/     \/|__|              \/    #
#                                               #
#################################################

# ========================================
# Build-specific configuration
# ========================================
if(IS_BUILDING_PACPUS)
	if(PACPUS_INSTALL_WITH_VERSION_NUMBER)
		pacpus_purge_backslash(PACPUS_INSTALL_DIR)
		set(PACPUS_INSTALL_DIR ${PACPUS_INSTALL_DIR}/${Pacpus_VERSION} )
	endif()
    set(PACPUS_INSTALL_3RD    FALSE                     CACHE BOOL      "Installation of the 3rd party")
endif()

# ========================================
# Global configuration
# ========================================
set(PACPUS_USE_LOG              TRUE  CACHE BOOL "Logging using Boost.Log, the library is required")
set(PACPUS_LOG_COLORED_OUTPUT   TRUE CACHE BOOL "Logging in color.")
set(PACPUS_INSTALL_3RD          FALSE CACHE BOOL "Installation of the 3rd party")
set(PACPUS_BUILD_DOC            FALSE CACHE BOOL "Whether build the documentation - requires Doxygen")
set(PACPUS_BUILD_EXAMPLES       TRUE CACHE BOOL "Whether build the examples")
set(PACPUS_USE_SOLUTION_FOLDERS TRUE CACHE BOOL "Use solution folders to classify projects, works in MS Visual Studio")

if(PACPUS_USE_SOLUTION_FOLDERS)
    if(CMAKE_VERSION VERSION_GREATER "2.8.0")
        set_property(GLOBAL PROPERTY USE_FOLDERS ON)
    else()
        message(AUTHOR_WARNING "Folders are only supported with CMake 2.8.0 and newer, and MSVC 2005 and newer except for 2005/2008/2010 Express Edition")
    endif()
endif(PACPUS_USE_SOLUTION_FOLDERS)


if(PACPUS_USE_LOG)
    list(APPEND PACPUS_DEFINITIONS " -DPACPUS_USE_LOG=1 ")
endif()

if(PACPUS_LOG_COLORED_OUTPUT)
    list(APPEND PACPUS_DEFINITIONS " -DPACPUS_LOG_COLORED_OUTPUT=1 ")
endif()
