// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @file
/// @author  Gerald Dherbomez <firstname.surname@utc.fr>
/// @author  Marek Kurdej <firstname.surname@utc.fr>
/// @date    Month, Year
/// @version $Id: DbiteFileTypes.h 76 2013-01-10 17:05:10Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Detailed description.

#ifndef DEF_PACPUS_DBITEFILETYPES_H
#define DEF_PACPUS_DBITEFILETYPES_H

/// Basic file types
enum BasicType
{
    FILE_IMAGE = 0
    , FILE_CAN
    , FILE_TEXT
    , FILE_IMAGE3D
    , FILE_DBT_UNKNOWN          ///< Unknown file type
    , FILE_JPEG
    , STREAM8POSITION = 100
};

enum ExtendedType
{
    SIGNAL_PPS = 511
    , FILE_AUDIO
    , AUDIO_WAV
    , TYPE_DOUBLE = 518
    , TYPE_FLOAT
    , TYPE_INT
    , TYPE_INT64
    , DATA_PHYSIO = 600
};

enum UtcHeudiasycType
{
    WGS84_POSITION = 500
    , GPS_SYNCHRO_FRAME
    , TRAME_GGA = 514
    , TRAME_VTG
    , TRAME_GST
    , TRAME_GGA_DBL = 614
    , TRAME_HDT
    , TRAME_ROT
    , TRAME_GSV
    , TRAME_GSA
    , TRAME_RMC
    , TRAME_ZDA
    , DYNA_ROADYN
    , DYNA_HT500
    , DYNA_CUBE_RAWDATA
    , DATA_ABS = 517
    , GYRO_KVH = 522
    , TELEM_SICK
    , CORREVIT
    , SIG
    , LOC
    , DATA_INS = 540
    , DATA_ABS_CITROEN
    , VOLANT
    , DATA_3DMG
    , DATA_COMODOS
    , CROSSBOW_VG700
    , CARMEN_CAN_RAW = 2200
    , CARMEN_CAN_WHEELSPEED
    , CARMEN_CAN_SUSPENSION
    , CARMEN_CAN_RAWLATDYN
    , CARMEN_CAN_ODOMETRY
    , CARMEN_CAN_LATDYN
    , CARMEN_CAN_STEERINGWHEEL
    , FLUENCE_ZE_STEERINGWHEEL = 2300
    , FLUENCE_ZE_KINEMATICS
    , FLUENCE_ZE_GEARS
    , FLUENCE_ZE_FRONT_WHEELSPEED
    , FLUENCE_ZE_REAR_WHEELSPEED
    , FLUENCE_ZE_LOWSPEED
    , ZOE_STEERINGWHEEL        //begin copy from 0.1.x
    , ZOE_KINEMATICS
    , ZOE_GEARS
    , ZOE_FRONT_WHEELSPEED
    , ZOE_REAR_WHEELSPEED
    , ZOE_VEHICLESTATE
    , ZOE_INITION
    , PROVEL_MABXFEEDBACK 
    , PROVEL_MABXDIAG 
    , PROVEL_MABX100MS          //end copy from 0.1.x
    , RADAR_TRW_AC20 = 3000
    , SMS_RADAR = 4000          // by Arthur Miranda 2012-02-23 (PAMU Project)
    , FILE_MJPEG = 4096
    , GENERIC_LIDAR = 8000
    , TELEM_100 = 8192
    , TELEM_180
    , TELEM_360
    , TELEM_SICK_LDMRS
    , TELEM_SICK_LMS
    , ALASCA_XT = 8200
    , VELODYNE_RAW_SPHERIC_DATA = 8300
    , GENERIC_3D_POSE = 9000
};

enum StereoCameraType
{
    STEREO_RIGHT_IMAGE = 1982
    , STEREO_LEFT_IMAGE
    , CARMEN_VISUAL_ODOMETRY
    , CARMEN_LIDAR_DETECTION
    , CARMEN_VISUAL_DETECTOR
};

/// for the Renault's Case study
enum RenaultType
{
    FILE_FACELAB = 610
    , DBT_T_HEADWAY = 1001
    , DBT_PERC_T_HEADWAY
    , DBT_D_O_C_F_DIST
    , DBT_F_DIST
    , DBT_S_INDICATOR
    // Lane Changing
    , DBT_L_CHANGE
    , DBT_M_SPEED
    , DBT_V_I_L_SPEED
    , DBT_R_TIME
    , DBT_B_R_TIME
    , DBT_E_B_EPISOD
    // state of the road
    , DBT_R_STATE
    // Comments from the ergonom
    , DBT_COMMENTS
    // State of the HVI of the ADAS
    , DBT_ADAS
    , DBT_R_SPEED
    , DBT_TTC
    , DBT_D_BRAKE_ACTUATION
    , DBT_ACC_PED_RELEASE
    , DBT_COV_DISTANCE
    // classes of time headway: [2.0 2.5]  [1.5 2.0]  [1.0 1.5]  [0.5 1.0]  [0.0 0.5] -> c2
    , DBT_T_HEADWAY_CLASSES
};

enum SbasType
{
    DBT_SBAS_MT1 = 10001
    , DBT_SBAS_MT2 = 10002
    , DBT_SBAS_MT3 = 10003
    , DBT_SBAS_MT4 = 10004
    , DBT_SBAS_MT5 = 10005
    , DBT_SBAS_MT6 = 10006
    , DBT_SBAS_MT7 = 10007
    , DBT_SBAS_MT10 = 10010
    , DBT_SBAS_MT18 = 10018
    , DBT_SBAS_MT24 = 10024
    , DBT_SBAS_MT25 = 10025
    , DBT_SBAS_MT26 = 10026
};

enum UbloxType
{
    DBT_UBX_RXM_RAW = 10121
    , DBT_UBX_RXM_SFRB = 10122
    , DBT_UBX_NAV_CLOCK = 10110
    , DBT_UBX_NAV_POSLLH = 10111
    , DBT_UBX_NAV_POSUTM = 10112
    , DBT_UBX_NAV_SBAS = 10113
    , DBT_UBX_NAV_SOL = 10114
    , DBT_UBX_NAV_SVINFO = 10115
    , DBT_UBX_NAV_VELNED = 10116
};

enum SbfType
{
    DBT_SBF_FRAMERAW = 11000
    , DBT_SBF_MEASEPOCH = 11889
    , DBT_SBF_SHORTMEASEPOCH = 11890
    , DBT_SBF_GENMEASEPOCH = 11944
    , DBT_SBF_ENDOFMEAS = 11922

    , DBT_SBF_GPSNAV = 11891
    , DBT_SBF_GPSALM = 11892
    , DBT_SBF_GPSION = 11893
    , DBT_SBF_GPSUTC = 11894
    , DBT_SBF_GPSRAW = 11895
    , DBT_SBF_CNAVRAW = 11947

    , DBT_SBF_GEOMT00 = 11925
    , DBT_SBF_GEOPRNMASK = 11926
    , DBT_SBF_GEOFASTCORR = 11927
    , DBT_SBF_GEOINTEGRITY = 11928
    , DBT_SBF_GEOFASTCORRDEGR = 11929
    , DBT_SBF_GEONAV = 11896
    , DBT_SBF_GEODEGRFACTORS = 11930
    , DBT_SBF_GEONETWORKTIME = 11918
    , DBT_SBF_GEOALM = 11897
    , DBT_SBF_GEOIGPMASK = 11931
    , DBT_SBF_GEOLONGTERMCORR = 11932
    , DBT_SBF_GEOIONODELAY = 11933
    , DBT_SBF_GEOSERVICELEVEL = 11917
    , DBT_SBF_GEOCLOCKEPHCOVMATRIX = 11934
    , DBT_SBF_GEORAW = 11898

    , DBT_SBF_PVTCARTESIAN = 11903
    , DBT_SBF_PVTGEODETIC = 11904
    , DBT_SBF_POSCOVCARTESIAN = 11905
    , DBT_SBF_POSCOVGEODETIC = 11906
    , DBT_SBF_VELCOVCARTESIAN = 11907
    , DBT_SBF_VELCOVGEODETIC = 11908
    , DBT_SBF_DOP = 11909
    , DBT_SBF_PVTRESIDUALS = 11910
    , DBT_SBF_RAIMSTATISTICS = 11915
    , DBT_SBF_GEOCORRECTIONS = 11935
    , DBT_SBF_BASELINE = 11950
    , DBT_SBF_ENDOFPVT = 11921

    , DBT_SBF_ATTITUDEEULER = 11938
    , DBT_SBF_ATTITUDECOVEULER = 11939
    , DBT_SBF_ATTITUDEQUAT = 11940
    , DBT_SBF_ATTITUDECOVQUAT = 11941
    , DBT_SBF_AUXANTPOSITIONS = 11942
    , DBT_SBF_ENDOFATTITUDE = 11943

    , DBT_SBF_RECEIVERTIME = 11914
    , DBT_SBF_XPPSOFFSET = 11911
    , DBT_SBF_EXTEVENT = 11924

    , DBT_SBF_DIFFCORRIN = 11919
    , DBT_SBF_BASESTATION = 11949
    , DBT_SBF_BASELINK = 11948

    , DBT_SBF_TRACKINGSTATUS = 11912
    , DBT_SBF_RECEIVERSTATUS = 11913
    , DBT_SBF_RECEIVERSETUP = 11902

    , DBT_SBF_COMMENT = 11936
};

enum NaviflowType
{
    TRAME_3DMGX1 = 12100
    , TRAME_AVIONIQUE = 12101
    , TRAME_UEYE_STEREO_INDEX = 12102
};

enum MobileyeType
{
    MOBILEYE_OBSTACLE_COUNT = 12200

    , MOBILEYE_OBSTACLE_0_PART_1 = 12210
    , MOBILEYE_OBSTACLE_1_PART_1 = 12211
    , MOBILEYE_OBSTACLE_2_PART_1 = 12212
    , MOBILEYE_OBSTACLE_3_PART_1 = 12213
    , MOBILEYE_OBSTACLE_4_PART_1 = 12214
    , MOBILEYE_OBSTACLE_5_PART_1 = 12215
    , MOBILEYE_OBSTACLE_6_PART_1 = 12216
    , MOBILEYE_OBSTACLE_7_PART_1 = 12217
    , MOBILEYE_OBSTACLE_8_PART_1 = 12218
    , MOBILEYE_OBSTACLE_9_PART_1 = 12219

    , MOBILEYE_OBSTACLE_0_PART_2 = 12220
    , MOBILEYE_OBSTACLE_1_PART_2 = 12221
    , MOBILEYE_OBSTACLE_2_PART_2 = 12222
    , MOBILEYE_OBSTACLE_3_PART_2 = 12223
    , MOBILEYE_OBSTACLE_4_PART_2 = 12224
    , MOBILEYE_OBSTACLE_5_PART_2 = 12225
    , MOBILEYE_OBSTACLE_6_PART_2 = 12226
    , MOBILEYE_OBSTACLE_7_PART_2 = 12227
    , MOBILEYE_OBSTACLE_8_PART_2 = 12228
    , MOBILEYE_OBSTACLE_9_PART_2 = 12229

    , MOBILEYE_OBSTACLES = 12290

    , MOBILEYE_CENTER_LANE = 12300
    , MOBILEYE_RIGHT_LANE = 12301
    , MOBILEYE_LEFT_LANE = 12302
};

enum SpanCptType
{
    TRAME_BESTGPSPOSA = 621
    , TRAME_RAWIMUSA = 622
    , TRAME_INSPVAA = 623
    , TRAME_INSCOV = 624
};

#endif // DEF_PACPUS_DBITEFILETYPES_H
