#include <Pacpus/kernel/ConnectionBase.h>

using namespace pacpus;

ConnectionBase::ConnectionBase(AbstractInterface * anInterface, int priority)
    : m_interface(anInterface)
    , m_priority(priority)
{}

ConnectionBase::~ConnectionBase()
{}

AbstractInterface * ConnectionBase::getInterface() const
{
    return m_interface;
}

int ConnectionBase::getPriority() const
{
    return m_priority;
}

bool ConnectionBase::operator==(ConnectionBase const & c)
{
    return getInterface() == c.getInterface()
        && getPriority() == c.getPriority()
    ;
}
