#include "ConsumerExample.h"

#include <Pacpus/kernel/ComponentFactory.h>
#include <Pacpus/kernel/Log.h>
#include <Pacpus/kernel/InputOutputInterface.h>

using namespace pacpus;
using namespace std;

DECLARE_STATIC_LOGGER("pacpus.cityvip.test.ConsumerExample");

PACPUS_REGISTER_COMPONENT(ConsumerExample);

ConsumerExample::ConsumerExample(QString name)
    : ComponentBase(name)
{
    LOG_TRACE("constructor(" << name << ")");

    addParameter("output-path", value<std::string>(&mOutputFileName)->default_value("consumer.txt"), "set output file path");
}

ConsumerExample::~ConsumerExample()
{
    LOG_TRACE("destructor");
}

void ConsumerExample::addInputs()
{
    addInput<QImage, ConsumerExample>("image", &ConsumerExample::process);
}

void ConsumerExample::addOutputs()
{
    // empty: no outputs
}

ComponentBase::COMPONENT_CONFIGURATION
ConsumerExample::configureComponent(XmlComponentConfig /*config*/)
{
    PACPUS_LOG_FUNCTION();

    // load XML parameters -- NOT NEEDED - loaded by boost::program_options (used addParameters())

    LOG_INFO("component '" << getName() << "' configured");
    return ComponentBase::CONFIGURED_OK;
}

void ConsumerExample::startActivity()
{
    LOG_TRACE(Q_FUNC_INFO);
    m_counter = 0;
    
    m_file.open(mOutputFileName.c_str(), std::ios_base::out | std::ios_base::app);
    if (!m_file.is_open()) {
        LOG_ERROR("file '" << mOutputFileName << "' cannot be opened");
    }

    setState(MONITOR_OK);
    LOG_INFO("started component '" << getName() << "'");

    moveToThread(&mThread);
    mThread.start();
}

void ConsumerExample::stopActivity()
{
    LOG_TRACE(Q_FUNC_INFO);

    m_file.close();
    setState(STOPPED);
    LOG_INFO("stopped component '" << getName() << "'");
    QMetaObject::invokeMethod(&mThread, "quit");
}

void ConsumerExample::process(const QImage& matrix)
{
    m_file << ++m_counter << " " << road_time() << "\n" << std::flush;

    LOG_INFO("Received QIMage: "
        << "size = " << matrix.size().width()<< " x " << matrix.size().height()
        );

    // DO PROCESSING

    setState(MONITOR_OK);
}

void testPacpusTypedEventConverts()
{
    PacpusTypedEvent<float> floatEvent(TYPED_EVENT, 1.0f);
    PacpusTypedEvent<double> doubleEvent = floatEvent;
    
    PacpusTypedEvent<int> intEvent(TYPED_EVENT, 2);
    //PacpusTypedEvent<QImage> imageEvent = intEvent; // should not compile
}
