// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @file
/// @author  Gerald Dherbomez <firstname.surname@utc.fr>
/// @date    January, 2007
/// @version $Id: ShMem.h 76 2013-01-10 17:05:10Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Detailed description.

#ifndef PACPUS_SHARED_MEMORY_H
#define PACPUS_SHARED_MEMORY_H

#include "PacpusToolsConfig.h"
#include "ShMemBase.h"

#include <Pacpus/kernel/deprecated.h>
#include <Pacpus/predef/compiler.h>
#include <Pacpus/predef/os.h>

#if PACPUS_OS_WINDOWS
/// Windows handle (opaque pointer) type definition
typedef void * HANDLE;
#elif PACPUS_OS_UNIX
#   include <QSharedMemory>
#   include <QSystemSemaphore>
#endif

#if PACPUS_COMP_MSVC
#   pragma warning(push)
#   pragma warning(disable: 4275)
#endif // PACPUS_COMP_MSVC

namespace pacpus
{

/// Shared memory class.
class /*PACPUSTOOLS_API*/ SharedMemory
    : public ShMemBase
{
public:
    /// Ctor of shared memory class.
    ///
    /// Creates a shared memory of size @b size and named @b name.
    /// If a shared memory with the name @b name already exists, than
    /// it will return object pointing to the same memory.
    /// If this existing memory space has a size smaller than @b size,
    /// a warning will be issued.
    ///
    /// @param name Name of the created shared memory space.
    /// @param size Size of the created shared memory space in [bytes].
    SharedMemory(const char* name, int size);

    /// Dtor of shared memory class.
    virtual ~SharedMemory();

    /// Returns pointer to shared memory
    virtual void* read();
    /// Copies a chunk of shared memory to dst buffer
    virtual void read(void* dst, int size);

    /// Use this method to write data in shared memory. Offset is given in bytes
    virtual void write(void* data, int size, unsigned long offset = 0);

    /// Use this method to wait the incoming of new data
    /// you can specify a timeout in ms to avoid infinite blocking or 0 (infinite)
    /// @returns @b true if new data available before the timeout, @b false otherwise
    virtual bool wait(unsigned long timeout = 0);

    /// Function that locks access to the shared memory
    virtual void lockMemory();
    /// Function that unlocks access to the shared memory
    virtual void unlockMemory();

    /// Returns event handle on Windows and NULL on Unix.
    virtual void* getEventIdentifier();

private:
#if PACPUS_OS_WINDOWS
    HANDLE semaphore_;
    HANDLE shMemHandle_;
    HANDLE event_;
#elif PACPUS_OS_UNIX
    QSystemSemaphore* event_;
    QSharedMemory* memory_;
#endif
};

// FIXME: rename references and remove
PACPUS_DEPRECATED(typedef SharedMemory ShMem);

} // namespace pacpus

#if PACPUS_COMP_MSVC
#   pragma warning(pop)
#endif // PACPUS_COMP_MSVC

#endif // PACPUS_SHARED_MEMORY_H
