// %pacpus:license{
// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// %pacpus:license}
/// @file
/// @author  Marek Kurdej <firstname.surname@utc.fr>
/// @date    2014-04-07 10:36:35
/// @version $Id$
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Detailed description.

#ifndef PACPUS_PREDEF_COMPILER_H
#define PACPUS_PREDEF_COMPILER_H

#include <Pacpus/predef/version_number.h>

////////////////////////////////////////////////////////////////////////////////

#define PACPUS_COMP_MSVC PACPUS_VERSION_NUMBER_NOT_AVAILABLE

#if defined(_MSC_VER)
#   undef PACPUS_COMP_MSVC
#   if !defined (_MSC_FULL_VER)
#       define PACPUS_COMP_MSVC_BUILD 0
#   else
        /* how many digits does the build number have? */
#       if _MSC_FULL_VER / 10000 == _MSC_VER
            /* four digits */
#           define PACPUS_COMP_MSVC_BUILD (_MSC_FULL_VER % 10000)
#       elif _MSC_FULL_VER / 100000 == _MSC_VER
            /* five digits */
#           define PACPUS_COMP_MSVC_BUILD (_MSC_FULL_VER % 100000)
#       else
#           error "Cannot determine build number from _MSC_FULL_VER"
#       endif
#   endif
#   define PACPUS_COMP_MSVC PACPUS_VERSION_NUMBER(\
        _MSC_VER/100-6,\
        _MSC_VER%100,\
        PACPUS_COMP_MSVC_BUILD)
#endif

#if PACPUS_COMP_MSVC
#   define PACPUS_COMP_MSVC_AVAILABLE
#endif

#define PACPUS_COMP_MSVC_NAME "Microsoft Visual C/C++"

////////////////////////////////////////////////////////////////////////////////

#define PACPUS_COMP_GNUC PACPUS_VERSION_NUMBER_NOT_AVAILABLE

#if defined(__GNUC__)
#   undef PACPUS_COMP_GNUC
#   if !defined(PACPUS_COMP_GNUC) && defined(__GNUC_PATCHLEVEL__)
#       define PACPUS_COMP_GNUC \
            PACPUS_VERSION_NUMBER(__GNUC__,__GNUC_MINOR__,__GNUC_PATCHLEVEL__)
#   endif
#   if !defined(PACPUS_COMP_GNUC)
#       define PACPUS_COMP_GNUC \
            PACPUS_VERSION_NUMBER(__GNUC__,__GNUC_MINOR__,0)
#   endif
#endif

#if PACPUS_COMP_GNUC
#   define PACPUS_COMP_GNUC_AVAILABLE
#endif

#define PACPUS_COMP_GNUC_NAME "Gnu GCC C/C++"

////////////////////////////////////////////////////////////////////////////////

#define PACPUS_COMP_CLANG PACPUS_VERSION_NUMBER_NOT_AVAILABLE

#if defined(__clang__)
#   undef PACPUS_COMP_CLANG
#   define PACPUS_COMP_CLANG PACPUS_VERSION_NUMBER(__clang_major__,__clang_minor__,__clang_patchlevel__)
#endif

#if PACPUS_COMP_CLANG
#   define PACPUS_COMP_CLANG_AVAILABLE
#endif

#define PACPUS_COMP_CLANG_NAME "Clang"

////////////////////////////////////////////////////////////////////////////////

#endif // PACPUS_PREDEF_COMPILER_H
