//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// DBC Decriptor                                                              //
//                                                                            //
// Made by Pierre Hudelaine                                                   //
//                                                                            //
// Contact: pierre.hudelaine@hds.utc.fr                                       //
//                                                                            //
// Translate a DBC file to Pacpus code                                        //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

#ifndef STRUCTURE_H
#define STRUCTURE_H


/// Structure of a complete signal
typedef struct {
    QString signalName; /// Signal name
    int     startBit;   /// Startbit of the signal
    int     length;     /// Length of the signal
    bool    order;      /// Encoding type; true bigEndian; false littleEndian
    bool    valueType;  /// Signe type; true signed; false unsigned
    double  gain;       /// Gain of the signal
    double  offset;     /// Offset of the signal
    double  max;        /// Max of the value
    double  min;        /// Min of the value
    QString unit;       /// Unit of the signal
    QString comment;    /// Associate comment of the signal
    QString description;/// Value description
} StructSignal;


/// Strucure of a complete frame
typedef struct {
    int numberOfSignals;    /// Number of signal per frame
    int frameID;            /// Frame ID
    QString frameName;      /// Frame name
    QVector<StructSignal> signalsVector; /// Signals of the frame
} StructFrame;


/// Structure of a complete dbc file
typedef struct {
    QVector<StructFrame> canFrames; /// Frames of the file
    QString              fileName;  /// Path to the dbc file
    QStringList          content;   /// Content of the dbc file
} StructDBCFile;


/// define the mnemonique of each message to find
#define signalMnemo " SG_"
#define signalInfoMnemo "BO_"
#define commentMnemo "CM_"
#define valueInfoMnemo "VAL_"


static const QString templateHFile =
"/*******************************************************************************\n" \
"//  created:\n" \
"//\n" \
"//  author:     Generated automatically with DBC decriptor\n" \
"//              Copyright Heudiasyc UMR UTC/CNRS 7253\n" \
"//\n" \
"//  version:    $Id: $\n" \
"//\n" \
"//  purpose:\n" \
"//\n" \
"*******************************************************************************/\n" \
"\n" \
"#ifndef __CanFrame_h__\n" \
"#define __CanFrame_h__\n" \
"\n" \
"#include \"CanGateway/CanFrameBase.h\"\n" \
"#include \"structureCan.h\"\n" \
"\n" \
"namespace pacpus {\n" \
"\n" \
"class CAN_API CanFrame\n" \
"       : public CanFrameBase\n" \
"{\n" \
"public:\n" \
"    CanFrame() {}\n" \
"    ~CanFrame() {}\n" \
"    void decode();\n" \
"    void * data() { return &data_; }\n" \
"    int size() { return sizeof(Struct); }\n" \
"\n" \
"protected:\n" \
"\n" \
"private:\n" \
"    Struct data_;\n" \
"};\n" \
"\n" \
"}\n" \
"\n" \
"#endif;";

static const QString templateCPPFile =
"/*******************************************************************************\n" \
"//  created:\n" \
"//\n" \
"//  author:     Generated automatically with DBC decriptor\n" \
"//              Copyright Heudiasyc UMR UTC/CNRS 7253\n" \
"//\n" \
"//  version:    $Id: $\n" \
"//\n" \
"//  purpose:\n" \
"//\n" \
"*******************************************************************************/\n" \
"\n" \
"\n" \
"#include \"CanFrame.h\"\n" \
"#include <iostream>\n" \
"\n" \
"using namespace pacpus;\n" \
"\n" \
"void CanFrame::decode()\n" \
"{\n" \
"	long long lltmp = 0;\n" \
"	unsigned long long ulltmp = 0;\n" \
"	long ltmp = 0;\n" \
"	unsigned long ultmp = 0;\n" \
"	short stmp = 0;\n" \
"	unsigned short ustmp = 0;\n" \
"	char ctmp = 0;\n" \
"	unsigned char uctmp = 0;\n" \
"};";

static const QString templateStructFile =
"/*******************************************************************************\n" \
"//  created:\n" \
"//\n" \
"//  author:     Generated automatically with DBC decriptor\n" \
"//              Copyright Heudiasyc UMR UTC/CNRS 7253\n" \
"//\n" \
"//  version:    $Id: $\n" \
"//\n" \
"//  purpose:\n" \
"//\n" \
"*******************************************************************************/\n" \
"\n" \
"#ifndef __STRUCTURECAN_H__\n" \
"#define __STRUCTURECAN_H__\n" \
"\n" \
"#include <cstddef>\n" \
"\n" \
"#include \"Pacpus/kernel/cstdint.h\"\n" \
"#include \"Pacpus/kernel/road_time.h\"\n" \
"\n" \
"\n" \
"#endif";

#endif // STRUCTURE_H
