/**
 *
 * This file is part of the PACPUS framework distributed under the 
 * CECILL-C License, Version 1.0.
 * 
 * @author  Samuel Gosselin
 * @date    December, 2012
 * @version $Id$
 * @copyright Copyright (c) UTC/CNRS Heudiasyc 2005 - 2013. All rights reserved.
 * @brief  Periodic worker base class
 *
 * Detailed description of file...
 * 
 */


// Includes, pacpus.
#include <Pacpus/PacpusTools/PeriodicWorker.h>

// Includes, qt.
#include <QTimer>

using namespace pacpus;

PeriodicWorker::PeriodicWorker()
  : AsyncWorkerBase()
  , mHeartbeat(NULL)
{
  mHeartbeat = new QTimer(this);
}

PeriodicWorker::~PeriodicWorker()
{
}

void
PeriodicWorker::startWork(int msec)
{
  mHeartbeat->start(msec);
  connect(mHeartbeat, SIGNAL(timeout()), this, SLOT(doWork()));
  
  this->start();
}

void
PeriodicWorker::stopWork()
{
  disconnect(mHeartbeat, SIGNAL(timeout()), this, SLOT(doWork()));
}
