#include  <Pacpus/kernel/ConnectionManager.h>
#include  <Pacpus/kernel/Log.h>

using namespace pacpus;

DECLARE_STATIC_LOGGER("pacpus.core.ConnectionManager");

ConnectionManager::ConnectionManager()
{
    LOG_TRACE("constructor");
}

ConnectionManager::~ConnectionManager()
{
    LOG_TRACE("destructor");
}

ConnectionManager * ConnectionManager::getInstance()
{
    LOG_TRACE("getInstance()");
    LOG_TRACE("before:  mInstance = " << mInstance);

    if (!mInstance)
    {
        LOG_INFO("creating new instance...");
        mInstance = new ConnectionManager();
        LOG_DEBUG("mInstance = " << mInstance);
    }

    LOG_TRACE("after:   mInstance = " << mInstance);
    return mInstance;
}

//void ConnectionManager::LoadConnection()

void ConnectionManager::setConnection()
{
    LOG_TRACE(Q_FUNC_INFO);

    ComponentManager * mgr = ComponentManager::getInstance();

    // TODO read XML file and build ConnectionList
    QList<ConnectionDescriptor> ConnectionList;
    ConnectionList.append(ConnectionDescriptor("testComponent1", "image", "testComponent2", "image", "type"));

    ComponentBase * sender, * receiver;
    InputInterfaceBase * in;
    OutputInterfaceBase * out;

    for (QList<ConnectionDescriptor>::iterator i = ConnectionList.begin(); i != ConnectionList.end(); ++i) {
        // TODO Handle errors
        sender = mgr->getComponent(i->_outputComponent);
        out = sender->getOutput(i->_outputName);

        receiver = mgr->getComponent(i->_inputComponent);
        in = receiver->getInput(i->_inputName);

        //connect(out,SIGNAL(),in,SLOT());  // TODO make connection

        LOG_INFO(" Output " << "out" << " connected to " << "in") // TODO replace out / in
    }

//    CledComponent * cledComponent = (CledComponent*) m_component[cName];

//    InputInterface<ScanAlascaData> * in1 = static_cast<InputInterface<ScanAlascaData> *> (cledComponent->input.at(0));
//    OutputInterface<ScanAlascaData> * out1 = static_cast<OutputInterface<ScanAlascaData> *> (cledComponent->output.at(0));

//    if(in1->getDataType() != out1->getDataType())
//        LOG_ERROR("Connection  Error: Incomaptible dataType between " << cledComponent->getName() << " and " << cledComponent->getName());


//    PacpusBuffer * buffer = new PacpusBuffer(5,in1->getDataSize());
//    LOG_INFO("Device opened:" << buffer->open(QIODevice::ReadWrite));

//    in1->setConnection(buffer,true);
//    out1->setConnection(buffer,true);
}
