#ifndef GENERIC_STRUCTURES_H
#define GENERIC_STRUCTURES_H

#include <Pacpus/PacpusTools/pacpusStruct.h>
#include <QVariant>
#include <QVector>
#include <QMatrix4x4>
#include <QImage>

namespace pacpus {

class Pose3D : public PacpusTimeStampedData {
public:
    QVector3D position;
    QVector3D angle;
    //QMatrix3x3 poscov;
    //QMatrix3x3 angconv;
    QMatrix4x4 transform;
};

class PacpusImage : public PacpusTimeStampedData {
public:
    QImage image;
};

} // end namespace pacpus

Q_DECLARE_METATYPE(pacpus::PacpusImage)
inline QDataStream & operator << (QDataStream & out, const pacpus::PacpusImage & Valeur){
    out << (quint64)Valeur.time << Valeur.timerange << Valeur.image;
    return out;
}

inline QDataStream & operator >> (QDataStream & in, pacpus::PacpusImage & Valeur){
    in >> (quint64&)Valeur.time >> Valeur.timerange >> Valeur.image;
    return in;
}

Q_DECLARE_METATYPE(pacpus::Pose3D)
inline QDataStream & operator << (QDataStream & out, const pacpus::Pose3D & Valeur){
    out << (quint64)Valeur.time << Valeur.timerange << Valeur.position << Valeur.angle << Valeur.transform;
    return out;
}

inline QDataStream & operator >> (QDataStream & in, pacpus::Pose3D & Valeur){
    in >> (quint64&)Valeur.time >> Valeur.timerange >> Valeur.position >> Valeur.angle >> Valeur.transform;
    return in;
}

#endif // GENERIC_STRUCTURES_H
