//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// DBC Decriptor                                                              //
//                                                                            //
// Made by Pierre Hudelaine                                                   //
//                                                                            //
// Contact: pierre.hudelaine@hds.utc.fr                                       //
//                                                                            //
// Translate a DBC file to Pacpus code                                        //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QListWidgetItem>

#include "structure.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private Q_SLOTS:
    void openDBCFile();
    void printFrame(int i, int j);
    void printAllFrames();
    void getSignalParameters(QString actualLine, StructFrame * actualCanFrame);
    void clearDBC();
    void findComment(int k);
    void findValueDescription(int k);
    void on_listWidget_signals_currentRowChanged(int currentRow);
    void on_pushButton_generate_clicked();
    void on_lineEdit_export_name_textChanged(const QString &arg1);

    void on_pushButton_output_path_clicked();

private:
    Ui::MainWindow *ui;
    StructDBCFile dbcFiles_;
};

#endif // MAINWINDOW_H
