/*********************************************************************
//  created:    2014/02/02
//  filename:   SickSocket.h
//
//  author:     Gerald Dherbomez & Cyril Fougeray
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Defintion of the SickSocket class
//              Management of the socket connection with Sick sensors
*********************************************************************/

#ifndef _SICKSOCKET_H_
#define _SICKSOCKET_H_

#include <cmath>
#include <QObject>
#include <QTcpSocket>
#include <QMutex>
#include <QEvent>

#include "Pacpus/kernel/road_time.h"

namespace pacpus {

class AbstractSickSensor;

// Sensors classes :
class SickLDMRSSensor;
class SickLMSSensor;

class SickFrame
{
public:
    SickFrame()
    {
        size = 0;
        time = 0;
        msg = NULL;
    }
    
    ~SickFrame()
    {
        delete[] msg; // check for NULL is not necessary
    }
    
    qint64 size;
    road_time_t time; 
    char * msg; 
};

// forward declaration

class SickFrameEvent
        : public QEvent
{
public:
    SickFrameEvent()
            : QEvent((QEvent::Type)(QEvent::User + 522))
    {}
    
    ~SickFrameEvent()
    {}
    
    SickFrame * frame;
};

class SickSocket
        : public QObject
{
  Q_OBJECT 
 
public:
    SickSocket(AbstractSickSensor * parent);
    ~SickSocket();

public Q_SLOTS:
    // enable the connection to the server
    void connectToServer(QString host, int port);

    //avertit que le socket est connect
    int socketConnected();

    // appel lorsque de nouvelles donnes sont arrives sur le socket
    void socketReadyRead();  

    // close the connection with the server 
    void closeSocket() { socket->close(); }

    // fonction d'envoi des donnes au tlmtre
    void sendToServer(QString data);
Q_SIGNALS:
    // signal emis pour demander la configuration du tlmtre 
    void configuration(); 

protected slots:

    // le socket est ferm par le serveur
    void socketConnectionClosed();

    // une erreur est survenue
    void socketError(QAbstractSocket::SocketError e); 

private:
    QTcpSocket *socket; 
    QMutex mutex;

    AbstractSickSensor *myParent;
};

} // namespace pacpus

#endif // _SICKSOCKET_H_
