/*********************************************************************
//  created:    2012/06/24
//  filename:   CanDecoderBase.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: $
//
//  purpose:    Abstract class to interface with CanGateway. 
//
*********************************************************************/

#pragma once
#ifndef CANDECODERBASE
#define CANDECODERBASE

#include "CanGatewayConfig.h"
#include "Pacpus/kernel/ComponentBase.h"
#include "CanFrame.h"
#include "structureCan.h"

namespace pacpus {

class CANGATEWAY_API CanDecoderBase : public ComponentBase
{
public:
  CanDecoderBase(QString name);
  virtual ~CanDecoderBase();

  virtual void startActivity();
  virtual void stopActivity();
  virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config); 
  
  void setData(TimestampedCanFrame d) { d_ = d; process(); }
  
protected:
  TimestampedCanFrame d_;
  virtual void process() = 0;

private:
  //CanGateway * gateway_;
};

} // namespace pacpus

#endif // CANDECODERBASE
