/*********************************************************************
//  created:    2008/2/11 - 12:01
//  filename:   Win32CanInterface.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Windows specific management of the Can Interface
//
*********************************************************************/

#ifndef WIN32CANINTERFACE_H
#define WIN32CANINTERFACE_H

// we use the Vector driver
#ifdef WIN32
//#   define CAN_DRIVER_TYPE       VECTOR_CAN_DRIVER 
#   define CAN_DRIVER_TYPE       VECTOR_CANXL_DRIVER 
#else
#   define CAN_DRIVER_TYPE       IGEP_CAN_DRIVER
#endif

#include <iostream>
#include <qsemaphore.h>
#include <qthread.h>

#include "CanDecoderBase.h"

#include "driver/CanDriver.h"
#include "structureCan.h"

namespace pacpus {

class ShMem;

class Win32CanInterface
    : public QThread
{
public:
  Win32CanInterface(); 
  ~Win32CanInterface();

  enum DataSource {VectorCard, SharedMemory, PeakCard, XLVectorCard, igepCard};

  bool openInterface(const int number, const unsigned int speed);
  bool openInterface(char* port, char* accessMode);
  bool closeInterface(const int number);
  void stop();

  void setSignalSempahore(QSemaphore * semaphore) { semaphore_ = semaphore;};
  void setExchangeBuffer(TimestampedCanFrame * framesArray, const int framesArraySize);
  void setSource(DataSource source);
  CanDriver * canDriver_;
protected:
  void run(); 
  void vectorLoop();
  void shMemLoop();
  void peakLoop();
  void igepLoop();
  void vectorXlLoop();

private:
  CanFrame frame_;
  bool continue_;
  DataSource source_;

  QSemaphore *semaphore_;
  TimestampedCanFrame * receivedFrames_;
  int receivedFramesArraySize_;

  ShMem * shMem_;

  int counter_;
};

} // namespace pacpus

#endif // WIN32CANINTERFACE_H
