/**
 *
 * This file is part of the PACPUS framework distributed under the 
 * CECILL-C License, Version 1.0.
 * 
 * @author  Gerald Dherbomez
 * @date    December, 2012
 * @version $Id$
 * @copyright Copyright (c) UTC/CNRS Heudiasyc 2005 - 2013. All rights reserved.
 * 
 */

#ifndef DEF_PACPUS_COMPONENTFACTORY_H
#define DEF_PACPUS_COMPONENTFACTORY_H

#include <cassert>

#include <Pacpus/kernel/ComponentFactoryBase.h>

#include <QtGlobal>
#include <QString>

/** Register a component to the factory.
 * @className Name of the class, without the quotes.
 * @factoryName Name of the class in the factory.
 */
#define REGISTER_COMPONENT(className, factoryName) \
  static pacpus::ComponentFactory<className> sFactory(factoryName)

namespace pacpus {

/** ComponentFactory
 * @brief Use it to interface your components with the application.
 *
 * @example
 *   REGISTER_COMPONENT("DummyComponent", DummyComponent);
 */
template <typename T>
class ComponentFactory
    : public ComponentFactoryBase
{
public:
    /** Ctor of ComponentFactory, initialize the factory of the components of type @em T.
     * @param type Name of the type of the components.
     */
    ComponentFactory(const QString& type);
    
    /** Dtor of ComponentFactory. */
    virtual ~ComponentFactory();

    /** Get the name of the type of the components.
     * @return Name of the type of the components.
     */
    const QString& getType() const;

protected:
    virtual ComponentBase* instantiateComponent(const QString& name);
  
private:
    QString mType;
};

template <typename T>
ComponentFactory<T>::ComponentFactory(const QString& type)
  : mType(type)
{
    assert(!type.isEmpty());
    addFactory(this, mType);
}

template<typename T>
ComponentFactory<T>::~ComponentFactory()
{
}

template <typename T>
const QString& ComponentFactory<T>::getType() const
{
    return mType;
}

template<typename T>
ComponentBase* ComponentFactory<T>::instantiateComponent(const QString& name)
{
    return new T(name);
}

} // pacpus

#endif // DEF_PACPUS_DBITEEXCEPTION_H
