/// Point Grey Research Bumblebee XB3 acquisition component.
/// 
/// created @date 2012-07-25
/// @author Marek Kurdej
/// @version $Id: $

#ifndef _BUMBLEBEE_H_
#define _BUMBLEBEE_H_

#include <PGRFlyCapture.h>
#include <triclops.h>
#include <qthread.h>

#include "PtGreyCamerasExp.h"

#include "Pacpus/kernel/componentBase.h"
#include "Pacpus/kernel/DbiteFile.h"
#include "Pacpus/PacpusTools/ShMem.h"


namespace pacpus {

/// Sensor component for 3-camera system Point Grey Research Bumblebee XB3.
/// 
/// Acquires data and writes it to shared memory segments: "${component-name}-(left|right)".
/// Written images are already rectified.
/// Writing to shared memory uses semaphores for synchronization.
/// 
/// Configuration options:
///     verbose=INTEGER (verbosity level), default=0
///     recording=0|1   (is recording? 0=false, 1=true), default=0
class PTGREYCAMERAS_API BumblebeeXB3
    : public QThread
    , public ComponentBase
{
    Q_OBJECT

public:
    BumblebeeXB3(QString name);
    ~BumblebeeXB3();
    
    /// starts processing
    virtual void startActivity();

    /// stops processing
    virtual void stopActivity();

    /// configures component
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config); 

    /// thread execution loop
    void run();

private:
    TriclopsContext mTriclops;
    
    FlyCaptureContext mFlycapture;
    FlyCapturePixelFormat mPixelFormat;

    int mMaxCols, mMaxRows;

    bool mIsRecording;
    int mVerbosityLevel;

    size_t mMaxImageSize;

	bool THREAD_ALIVE;

    ShMem * mShMemLeft;
    //ShMem * mShMemTop;
    ShMem * mShMemRight;

    DbiteFile mDbtLeft;
    //DbiteFile mDbtTop;
    DbiteFile mDbtRight;
};

} // namespace pacpus

#endif /* !_BUMBLEBEE_H_ */
