/*********************************************************************
//  created:    2013/10/25 - 19:36
//  filename:   Flea3Component.h
//
//  author:     Danilo Alves de Lima
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    
*********************************************************************/

#ifndef FLEA3COMPONENT_H
#define FLEA3COMPONENT_H

#include "PtGreyCamerasExp.h"

#include <fstream>
#include <qcoreevent.h>
#include <qthread.h>
#include <string>

#include "Pacpus/kernel/ComponentBase.h"
#include "Pacpus/kernel/DbiteFile.h"
#include "Pacpus/PacpusTools/ShMem.h"

#include "FlyCapture2.h"

#include <QThread>
#include <QMutex>
#include <qdir.h>

#include "../../StdDbtPlayerComponents/ImageBaseStructure.h"

namespace pacpus {

/** Class to provide the obstacle detection from a disparity map data */
class PTGREYCAMERAS_API Flea3Component:	public QThread, 
										public ComponentBase
{
public:
	//============================= DEFAULT ELEMENTS ===============================================
    Flea3Component(QString name);
    ~Flea3Component();

    void run();

    virtual void stopActivity(); /*!< to stop the processing thread */
    virtual void startActivity(); /*!< to start the processing thread */
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
	//==============================================================================================
		
protected:

	// Indicates that thread is running
	bool is_running;

public:

	/** 
	* Initialize default values
	*/
	void InitDefault();

private:
	int cam_serial;						// Camera serial to connect
	
	// Camera configuration
	bool auto_FrameRate;				// Set auto frame rate
	double cam_FrameRate;				// Frame rates in frames per second
	bool auto_Gain;						// Set auto gain
	double cam_Gain;					// Gain value in db
	bool auto_Exposure;					// Set auto exposure
	double cam_Exposure;				// Auto exposure in EV
	bool auto_Shutter;					// Set auto shutter
	double cam_Shutter;					// Shutter in miliseconds
	bool auto_ExposurebyCode;			// Set auto exposure by pos processing method
	double cam_ExposurebyCode_tshold;	// Pecentage of white pixels for threshold

	int cam_video_mode;					// DCAM video modes
	int cam_mode;						// Camera modes for DCAM formats as well as Format7
	int cam_PixelFormat;				// Pixel formats available for Format7 modes
	int cam_ColorProcessingAlgorithm;	/**
										* Color processing algorithms. Please refer to our knowledge base at
										* article at http://www.ptgrey.com/support/kb/index.asp?a=4&q=33 for
										* complete details for each algorithm.
										*/
	int cam_start_point_left;			// Image left point (for standard modes only)
	int cam_start_point_top;			// Image top point (for standard modes only)
	int cam_width;						// Image width (for standard modes only)
	int cam_height;						// image height (for standard modes only)
	int cam_channels;					// Image channels (depending of the color processing method)

	//-------------------------------------------- Image save options ------------------------------------------------
	double image_scale;					// Image scale to save
	int image_compact;					// Use jpeg format to save the images
	int save2dbt;						// Save the image in the dbt file (to increases the save rate)

	size_t mSaveImageSize;				// Size of the image to be saved
	//----------------------------------------------------------------------------------------------------------------
	bool showdebug;						// Show frame acquired
		
	int mMaxImageOutputSize;		// Size of the input image data in the memory	
	
	// Output directory
	QDir mOutputDirectory;

	TimestampedStructImage ImageHeader;		// Image header
	void* img_mem;							// Memory position for the header + image data
	size_t img_mem_size;					// Memory size for the header + image data

	bool use_shmem;							// If is to use shared memory

	// Imput data
	ShMem * shmem_image;	// Shared memory control access to the image data

	DbiteFile mDbtImage;

	bool THREAD_ALIVE;
	bool stereoVision;
	QString cam_side;
};

}
#endif // FLEA3COMPONENT
