/*********************************************************************
//  created:    2012/03/01 - 14:06
//  filename:   VDisparity.h
//
//  author:     Pierre Hudelaine
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: $
//
//  purpose:    
//
*********************************************************************/

#include "Pacpus/kernel/Log.h"
#include "Pacpus/kernel/ComponentBase.h" 
#include "Pacpus/kernel/ComponentFactory.h"
#include "Pacpus/PacpusTools/ShMem.h"

#include "opencv2/opencv.hpp"

#include "StereoVisionDisparityExp.h"



namespace pacpus {

class STEREOVISIONDISPARITY_API VDisparity
        : public QObject
        , public ComponentBase 
{ 
  Q_OBJECT

public: 
    /// Constructor
    VDisparity(QString name);

    /// Destructor
    ~VDisparity();

protected:
    // The 3 virtual methods relative to the ComponentBase inheritance
    virtual void startActivity();
    virtual void stopActivity();
    virtual COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);

private:

	// Image reading
	ShMem * shMemLeft_, * shMemRight_;
	size_t  maxImageSize_, img_height_, img_width_;
	unsigned char * img_Ldata_, * img_Rdata_;

	// Image processing
	float theta_, sin_theta_, cos_theta_;
	int disp_min_, disp_max_, subsampling_;
	cv::Mat logR_;
	//unsigned char * logR_, * logB_, * v_dis_, * v_dis_o_, * n_, * mn_, * Icc_;

	void pre_detect();
	void multi_obc();
	void initMat();
};

} // namespace pacpus
