/*********************************************************************
//  created:    2012/03/01 - 14:06
//  filename:   VDisparite.cpp
//
//  author:     Pierre Hudelaine
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: $
//
//  purpose:    Create network socket if needed in Pacpus
//
*********************************************************************/

#include "VDisparity.h" 

using namespace pacpus;


DECLARE_STATIC_LOGGER("pacpus.base.VDisparity");


//////////////////////////////////////////////////////////////////////////
// Construct the factory
//////////////////////////////////////////////////////////////////////////
static ComponentFactory <VDisparity> sFactory("VDisparity");  


//////////////////////////////////////////////////////////////////////////
// Constructeur
//////////////////////////////////////////////////////////////////////////
VDisparity::VDisparity(QString name)
    : ComponentBase(name) 
{
	img_width_ = 1280;
	img_height_ = 960;

	initMat();

	maxImageSize_ = img_width_ * img_height_;
	this->img_Ldata_ = (unsigned char *)malloc(maxImageSize_);
	this->img_Rdata_ = (unsigned char *)malloc(maxImageSize_);
	shMemLeft_ = new ShMem("Changer nom", maxImageSize_);
    shMemRight_ = new ShMem("Changer nom", maxImageSize_);
} 


//////////////////////////////////////////////////////////////////////////
// Destructor
//////////////////////////////////////////////////////////////////////////
VDisparity::~VDisparity() 
{
	free(this->img_Ldata_);
	free(this->img_Rdata_);
}


//////////////////////////////////////////////////////////////////////////
// Called by the ComponentManager to pass the XML parameters to the 
// component 
//////////////////////////////////////////////////////////////////////////
ComponentBase::COMPONENT_CONFIGURATION  VDisparity::configureComponent(XmlComponentConfig config) 
{ 

	
	return ComponentBase::CONFIGURED_OK; 
} 


//////////////////////////////////////////////////////////////////////////
// Called by the ComponentManager to start the component
//////////////////////////////////////////////////////////////////////////
void VDisparity::startActivity() 
{
	// Imgae reading
	if (this->img_Ldata_ != NULL)
	{
		this->shMemLeft_->read(this->img_Ldata_, this->maxImageSize_);
		this->shMemRight_->read(this->img_Rdata_, this->maxImageSize_);
	}

	multi_obc();


}

//////////////////////////////////////////////////////////////////////////
// Called by the ComponentManager to stop the component
//////////////////////////////////////////////////////////////////////////
void VDisparity::stopActivity()
{

}


//////////////////////////////////////////////////////////////////////////
// 
//////////////////////////////////////////////////////////////////////////
void VDisparity::multi_obc()
{

}


//////////////////////////////////////////////////////////////////////////
// 
//////////////////////////////////////////////////////////////////////////
void VDisparity::pre_detect()
{

}


//////////////////////////////////////////////////////////////////////////
// 
//////////////////////////////////////////////////////////////////////////
void VDisparity::initMat()
{

}