/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

#ifndef DEF_PACPUS_XMLCONFIGFILE_H
#define DEF_PACPUS_XMLCONFIGFILE_H

#include <Pacpus/kernel/pacpus.h>
#include <Pacpus/kernel/XmlComponentConfig.h>

#include <QDomElement>
#include <QMutex>
#include <QStringList>

class QFile;

namespace pacpus {

/// XML config properties:
///     list            STRING(S)   name(s) of plugin files to be loaded, separated by pipe symbol '|'
///         e.g. dbt="libDbtPlyGps.so|libDbtPlyVision.so
class PACPUSLIB_API XmlConfigFile
{
    friend XmlComponentConfig::XmlComponentConfig(const QString&);
    friend class ComponentManager;

public:
    /// @todo Documentation
    static XmlConfigFile * create();
    /// @todo Documentation
    static void destroy();
    /// @todo Documentation
    QDomElement getComponent(QString name);
    /// @returns a list of all names of components declared in the XML tree
    QStringList getAllComponents();
    /// @todo Documentation
    QStringList getAllPlugins();
    /// @todo Documentation
    int loadFile(QString fileName);

    /// @todo Documentation
    /// not used
    void saveFile(QString fileName);
    /// @todo Documentation
    /// not used
    void addComponent(QDomElement component);
    /// @todo Documentation
    /// not used
    void delComponent(QDomElement component);

protected:
private:
    XmlConfigFile();
    ~XmlConfigFile();

    static XmlConfigFile * _xmlConfigFile;
    
    QDomElement createComponent(QString name);

private:
    QDomDocument _document;
    QFile * _file;
    QMutex _mutex;

    int _numberOfComponents;
};

} // namespace pacpus

#endif // DEF_PACPUS_XMLCONFIGFILE_H
