/*********************************************************************
//  created:    2012/03/01 - 14:06
//  filename:   TelnetClient.h
//
//  author:     Pierre Hudelaine
//              Copyright Heudiasyc UMR UTC/CNRS 7253
// 
//  version:    $Id: $
//
//  purpose:    Create network socket if needed in Pacpus
//
*********************************************************************/

#include <QTcpSocket>
#include <QHostAddress>

#include "Pacpus/kernel/Log.h"
#include "Pacpus/kernel/ComponentBase.h" 
#include "Pacpus/kernel/ComponentFactory.h" 

// Export macro for TelnetClient DLL for Windows only
#ifdef WIN32
#   ifdef TelnetClient_EXPORTS
        // make DLL
#       define TelnetClient_API __declspec(dllexport)
#   else
        // use DLL
#       define TelnetClient_API __declspec(dllimport)
#   endif
#else
    // On other platforms, simply ignore this 
#   define TelnetClient_API 
#endif

class QByteArray;

namespace pacpus {


class TelnetClient_API TelnetClient
        : public QObject
        , public ComponentBase 
{ 
  Q_OBJECT

public: 
    /// Constructor
    TelnetClient(QString name);

    /// Destructor
    ~TelnetClient();
    TelnetClient * getSocket() {return this;}

public Q_SLOTS:
    /// Slot de lecture des paquets envoys pour tests
    void readPendingDatagrams();

    /// Slot d'envoie des paquets
    //void sendDatagrams(QString frame);
    //void sendDatagrams(QByteArray frame);
    
Q_SIGNALS:
    void newDatagram(QByteArray datagram);
    void newQString(QString string);

public slots:
    void ConnectionMessage();

protected:
    // The 3 virtual methods relative to the ComponentBase inheritance
    virtual void startActivity();
    virtual void stopActivity();
    virtual COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);

    QTcpSocket * socket_; 

    quint16 port_;
    QHostAddress address_;         
      
};

} // namespace pacpus
