/*********************************************************************
//  created:    2013/10/25 - 19:36
//  filename:   Flea3Grabber.h
//
//  author:     Danilo Alves de Lima
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    
*********************************************************************/

#ifndef FLEA3GRABBER_H
#define FLEA3GRABBER_H

#include <QThread>
#include <QMutex>
#include <QDir>

#include "Pacpus/kernel/ComponentBase.h"
#include "Pacpus/kernel/DbiteFile.h"
#include "Pacpus/PacpusTools/ShMem.h"
#include "PtGreyCamerasExp.h"

#include "opencv2/objdetect/objdetect.hpp"
#include "opencv2/calib3d/calib3d.hpp"
#include "opencv2/imgproc/imgproc.hpp"
#include "opencv2/core/core.hpp"
#include "opencv2/highgui/highgui.hpp"

#include "FlyCapture2.h"
#include <string>
#include <vector>
#include "../../StdDbtPlayerComponents/ImageBaseStructure.h"

namespace pacpus {

typedef struct{
	// Camera configuration
	int cam_serial;						// Camera serial to connect
	bool auto_FrameRate;				// Set auto frame rate
	double cam_FrameRate;				// Frame rates in frames per second
	bool auto_Gain;						// Set auto gain
	double cam_Gain;					// Gain value in db
	bool auto_Exposure;					// Set auto exposure
	double cam_Exposure;				// Auto exposure in EV
	bool auto_Shutter;					// Set auto shutter
	double cam_Shutter;					// Shutter in miliseconds
	bool auto_ExposurebyCode;			// Set auto exposure by pos processing method
	double cam_ExposurebyCode_tshold;	// Pecentage of white pixels for threshold
	int cam_video_mode;					// DCAM video modes
	int cam_mode;						// Camera modes for DCAM formats as well as Format7
	int cam_PixelFormat;				// Pixel formats available for Format7 modes
	int cam_start_point_left;			// Image left point (for standard modes only)
	int cam_start_point_top;			// Image top point (for standard modes only)
	int cam_width;						// Image width (for standard modes only)
	int cam_height;						// image height (for standard modes only)
	int cam_channels;					// Image channels (depending of the color processing method)
	unsigned int cam_trigger_mode;		// Trigger mode
	unsigned int cam_trigger_enable;	// Trigger enable (1 on // 0 off)
	unsigned int cam_trigger_parameter;	
	unsigned int cam_trigger_polarity;	// Trigger polarity (0 low // 1 high)
	unsigned int cam_trigger_source;	// Source (GPIO)
	unsigned int cam_trigger_dest;		// Dest (GPIO) input/output
	unsigned int cam_strobe_source;		// Strobe source
	bool cam_strobe_enable;				// Enable strobe mode
	unsigned int cam_strobe_polarity;	// Strobe polarity
	float cam_strobe_delay;
	float cam_strobe_duration;
	FlyCapture2::TimeStamp timeStamp;
	double distCoe[8];
	cv::Mat_<double> distCoeffs;
	double tmp_matrix[3][3];
	cv::Mat_<double> matrix;
	int cam_ColorProcessingAlgorithm;	/**
										* Color processing algorithms. Please refer to our knowledge base at
										* article at http://www.ptgrey.com/support/kb/index.asp?a=4&q=33 for
										* complete details for each algorithm.
										*/
	//-------------------------------------------- Image save options ------------------------------------------------
	double image_scale;					// Image scale to save
	int image_compact;					// Use jpeg format to save the images
	int save2dbt;						// Save the image in the dbt file (to increases the save rate)

	size_t mSaveImageSize;				// Size of the image to be saved
	//----------------------------------------------------------------------------------------------------------------
	bool showdebug;						// Show frame acquired
		
	int mMaxImageOutputSize;			// Size of the input image data in the memory	
	
	// Output directory
	QDir mOutputDirectory;

	TimestampedStructImage ImageHeader;		// Image header
	void* img_mem;							// Memory position for the header + image data
	size_t img_mem_size;					// Memory size for the header + image data

}camSetting;

/** Class to provide the obstacle detection from a disparity map data */
class PTGREYCAMERAS_API Flea3Grabber:	public QThread, 
										public ComponentBase
{
public:
	//============================= DEFAULT ELEMENTS ===============================================
    Flea3Grabber(QString name);
    ~Flea3Grabber();

    void run();

    virtual void stopActivity(); /*!< to stop the processing thread */
    virtual void startActivity(); /*!< to start the processing thread */
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
	//==============================================================================================
		
protected:

	// Indicates that thread is running
	bool is_running;
	DbiteFile mDbtImage;
	bool use_shmem;							// If is to use shared memory
	bool shmem_corrected;
	bool THREAD_ALIVE;

public:

	/** 
	* Initialize default values
	*/
	void InitDefault(int indice);

private:
	int nbrCamera_;
	int masterCamera_;
	float rot_[3], trans_[3];

	ShMem * img_sending_;

	std::vector<camSetting> settings_;
	std::vector<ShMem*> shmem_images_;
};

}
#endif // FLEA3GRABBER
