/*********************************************************************
//  created:    2013/12/06 - 16:10
//  filename:   ImageBaseStructure.h
//
//  author:     Danilo Alves de Lima
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    Guard the image basic information to send by shared 
//				memory
//
*********************************************************************/

#ifndef __IMAGEBASE_STRUCTURE_h__
#define __IMAGEBASE_STRUCTURE_h__

#include "Pacpus/kernel/road_time.h"

// Image data structure
typedef struct
{
    size_t width;				// Image width
    size_t height;				// Image height
	size_t channels;			// Image number of channels
	size_t width_step;			// Image width step to change the line in the data
	size_t data_size;			// Image data size
} ImageDataStructure;

typedef struct
{
    road_time_t time;
    road_timerange_t timerange;
    ImageDataStructure image;
} TimestampedStructImage;

#endif // __IMAGEBASE_STRUCTURE_h__