/********************************************************************
//  created:    2011/02/21 - 10:39
//  filename:   PeakCanDriverWin.h
//
//  author:     Danilo Alves de Lima
//
//  version:    $Id: PeakCanDriverWin.h dalvesde $
//
//  purpose:    Inherits from the CanDriver class
//              Reimplement all the virtual members of the CanDriverBase
//              class in order to be used with the Peak driver.
//              platform : Windows specific
//
*********************************************************************/

#ifndef PEAKCANDRIVERWIN_H
#define PEAKCANDRIVERWIN_H

#include <windows.h>

#include "CanDriverBase.h"
#include "PCANBasic.h"
#include <fcntl.h>    // O_RDWR
#include <errno.h>
#include <string>

#define PSUCCESS                     0
#define READ_TIMEOUT                100000// 100 miliseconds timeout

class PeakCanDriverWin : public CanDriverBase
{
public:
  PeakCanDriverWin(void);
  PeakCanDriverWin(int);
  PeakCanDriverWin(const char* port, const char* mode);
  PeakCanDriverWin(int channel, unsigned int bitRate);
  ~PeakCanDriverWin(void);

  short initPort (void);
  short cleanUpPort (void);

  short sendFrame (struct CanFrame frame);
  short receiveFrame (struct CanFrame &frame);
  void waitReceivingFrame(void);

  enum OperationMode{ReadOnly, WriteOnly, ReadWrite};

protected:

private:
  char *  szDevNode_;
  OperationMode mode_;

  TPCANHandle       canDeviceHandle_;
  TPCANBaudrate		canBaudrate_;

  void print_message(TPCANMsg *m);

};

#endif // PEAKCANDRIVERWIN_H
