/*********************************************************************
//  created:	2008/07/18 - 15:33
//  filename:   SeptentrioSocket.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 6599
//
//  version:    $Id: $
//
//  purpose:
//
*********************************************************************/




#ifndef _SEPTENTRIOSOCKET_H_
#define _SEPTENTRIOSOCKET_H_


#define SBFBLOCK_MAX_LENGTH 4096
#define MAX_RESOURCES_COUNT 100

#include <QSemaphore>
#include <QObject>
#include <QTcpSocket>
#include <QMutex>
#include <math.h>
#include "kernel/road_time.h"
#include <queue>


using namespace std;


// forward declaration
class SeptentrioComponent;


////////////////////////
//  Septentrio frame  //
////////////////////////
/*! \typedef struct SbfFrame
    \brief Structure containing the received bytes timestamped
    timestamp expressed in microseconds since 01/01/1970,00:00
 */
typedef struct
{
    //! timestamp (in microsenconds)
    road_time_t time;
    //! timestamp uncertainty
    road_timerange_t timerange ;
    //! data
    unsigned char data[SBFBLOCK_MAX_LENGTH];
    //! length of valid data;
    short size;
} SbfFrame;




class SeptentrioSocket : public QObject
{
    Q_OBJECT

public:
    // constructor
    SeptentrioSocket();
    // destructor
    ~SeptentrioSocket();
    // the FIFO in which incoming data are buffered
    queue<SbfFrame> sbfFrames;
    // the semaphore to alert FIFO update
    QSemaphore sem;

public slots:
    // activate the connection to the server
    void connectToServer(QString host, int port);

    // called as soon as socket is connected
    int socketConnected();

    // called when new data available on the socket
    void socketReadyRead();

    // close the connection with the server
    void closeSocket()
    {
        socket_->close();
    }

    void sendToServer(QString data);

    int ID() {return socket_->socketDescriptor() ;};

protected slots:
// 		void sendToServer(QString data);


    // socket connection closed by the server
    void socketConnectionClosed();

    // error on the socket
    void socketError(QAbstractSocket::SocketError e);

private:
    // the socket
    QTcpSocket *socket_;

    // mutex used to serialize access to socket
    QMutex mutex_;

};

#endif // _SEPTENTRIOSOCKET_H_
