
#include <QThread>
#include <QSemaphore>
#include <QApplication>

#include "kernel/ComponentBase.h"
#include "kernel/ComponentFactory.h"

#ifdef WIN32
#include "../driver/win32SerialPort.h"
//#include "network/gpsServerSocket.h"
#else 
#include "../driver/PosixSerialPort.h"
#endif


#include "structure/structureUBX.h"
#include "SerialCom/SerialCOM_Handle_Stream.hpp"
#include "SerialCom/Ublox/SerialCOM_Protocol_UBX.hpp"
#include "SerialCom/NMEA/SerialCOM_Protocol_NMEA.hpp"
#include "SerialCom/SerialCOM_Msg.hpp"
#include "SerialCom/Ublox/SerialCOM_Msg_RXM_RAW.hpp"
#include "SerialCom/Ublox/SerialCOM_Msg_RXM_SFRB.hpp"
#include "SerialCom/Ublox/SerialCOM_Msg_NAV_CLOCK.hpp"
#include "SerialCom/Ublox/SerialCOM_Msg_NAV_POSLLH.hpp"
#include "SerialCom/Ublox/SerialCOM_Msg_NAV_POSUTM.hpp"
#include "SerialCom/Ublox/SerialCOM_Msg_NAV_SOL.hpp"
#include "SerialCom/Ublox/SerialCOM_Msg_NAV_VELNED.hpp"
#include "SerialCom/Ublox/SerialCOM_Msg_NAV_SBAS.hpp"
#include "SerialCom/Ublox/SerialCOM_Msg_NAV_SVINFO.hpp"


/*! \class ubloxComponent
 *	\brief DByte component used to record  ublox messages
 *	\author Olivier LE MARCHAND
 *	\version 1.0
 *	\date august 2009
 *	\bug Problem with the serial communication
 *	\warning None
 *	
 *	This class follows the DByte sensor architecture and acquire data from
 *  the ublox receiver with a serial communication port. Hence messages are
 *  decoded with the help of the SerialCOM librairy where Ublox protocol and
 *  Messages are implemeted.
 *
 */

class ubloxComponent : public QThread, public ComponentBase 
{
Q_OBJECT

public:
	/*! \brief Constructor. Create and configure objects from the SerialCOM librairy, and
	 *  intialize member variables*/
  ubloxComponent(QString name); 

	/*! \brief Detructor. Free the memory of the objects from the SerialCOM library*/
  ~ubloxComponent(); 

	/*! \brief Virtual function herited from ComponentBase. Start the thread and create 
	 *   and configure the serial port*/
  void startActivity();

  /*! \brief Virtual function herited from ComponentBase. Stop the thread and destroy 
   *   the serial port*/
  void stopActivity(); 

  /*! \brief Virtual function herited from ComponentBase. Configure part of the serial port
   *   with data contained in the xml configuration file*/
  ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config); 


  /*! \brief Virtual function herited from ComponentBase. Main loop of the thread*/
  /*! Receive data from the serial port, transmit it to the SerialCOM_Handle_Stream
   *  and record the data once a full message has been identified*/
  void run(); 

  /*! Serial Port object*/
#ifdef WIN32
  Win32SerialPort* serialPort;
#else
  PosixSerialPort *serialPort;
#endif

public slots: 
	/*! \brief to unlock the processing thread */
  void unlockProcessing(int v); 

protected: 
  /*! \brief data frame currently read from the serial com port */
  std::string currentDataFrame; 

  /*! \brief time of arrival of the current data frame at the serial port */
  road_time_t currentRoadtime; 

  /*! \brief time uncertainty on the currentRoadtime */
  road_timerange_t currentTimerange; 
   
 
  /*!\brief Object used to bufferize data and extract messages with the help of registered protocolhandle messages*/
  SerialCOM_Handle_Stream *pHandleStream;

  /*! Object to handle ublox protocol */
  Ublox::SerialCOM_Protocol_UBX *pProtocolUBX;

  /*! Object to handle NMEA protocol */
  NMEA::SerialCOM_Protocol_NMEA *pProtocolNMEA;
  
  QSemaphore semaphore; 

  /*!\brief Name of the serial port*/
  QString portName;

};

