#pragma once
#ifndef __GPS_FRAMES_H__
#define __GPS_FRAMES_H__

#include "Pacpus/kernel/cstdint.h"
#include "structure_gps.h"
#include "Pacpus/kernel/GenericObservable.h"


// Export macro for PluginTest DLL for Windows only
#ifdef WIN32
#   ifdef GPS_EXPORTS
        // make DLL
#       define GPS_FRAMES_API __declspec(dllexport)
#   else
        // use DLL
#       define GPS_FRAMES_API __declspec(dllimport)
#   endif
#else
    // On other platforms, simply ignore this 
#   define GPS_FRAMES_API /* nothing */
#endif

namespace pacpus {

template <typename T>
class GpsFrame {
public:
  T* getFrameData() { return &frame_; }
  const T* getFrameData() const { return &frame_; }
  road_time_t getRoadTime() const { return rdt_; }
  void setRoadTime(road_time_t rdt) { rdt_ = rdt; }
private:
  T frame_;
  road_time_t rdt_;
};



class GPS_FRAMES_API GpsGgaFrame
  : public GpsFrame<trame_gga_dbl>, public GenericObservable<GpsGgaFrame>
{
public:
  typedef trame_gga_dbl frameType;
  typedef GenericObservable<GpsGgaFrame>::ObserverType ObserverType;
};

class GPS_FRAMES_API GpsGsaFrame
  : public GpsFrame<trame_gsa>, public GenericObservable<GpsGsaFrame>
{
public:
  typedef trame_gsa frameType;
  typedef GenericObservable<GpsGsaFrame>::ObserverType ObserverType;
};

class GPS_FRAMES_API GpsGstFrame
  : public GpsFrame<trame_gst>, public GenericObservable<GpsGstFrame>
{
public:
  typedef trame_gst frameType;
  typedef GenericObservable<GpsGstFrame>::ObserverType ObserverType;
};

class GPS_FRAMES_API GpsGsvFrame
  : public GpsFrame<trame_gsv>, public GenericObservable<GpsGsvFrame>
{
public:
  typedef trame_gsv frameType;
  typedef GenericObservable<GpsGsvFrame>::ObserverType ObserverType;
};

class GPS_FRAMES_API GpsHdtFrame
  : public GpsFrame<trame_hdt>, public GenericObservable<GpsHdtFrame>
{
public:
  typedef trame_hdt frameType;
  typedef GenericObservable<GpsHdtFrame>::ObserverType ObserverType;
};

class GPS_FRAMES_API GpsRmcFrame
  : public GpsFrame<trame_rmc>, public GenericObservable<GpsRmcFrame>
{
public:
  typedef trame_rmc frameType;
  typedef GenericObservable<GpsRmcFrame>::ObserverType ObserverType;
};

class GPS_FRAMES_API GpsRotFrame
  : public GpsFrame<trame_rot>, public GenericObservable<GpsRotFrame>
{
public:
  typedef trame_rot frameType;
  typedef GenericObservable<GpsRotFrame>::ObserverType ObserverType;
};

class GPS_FRAMES_API GpsVtgFrame
  : public GpsFrame<trame_vtg>, public GenericObservable<GpsVtgFrame>
{
public:
  typedef trame_vtg frameType;
  typedef GenericObservable<GpsVtgFrame>::ObserverType ObserverType;
};

class GPS_FRAMES_API GpsZdaFrame
  : public GpsFrame<trame_zda>, public GenericObservable<GpsZdaFrame>
{
public:
  typedef trame_zda frameType;
  typedef GenericObservable<GpsZdaFrame>::ObserverType ObserverType;
};

class GPS_FRAMES_API GpsSynchro
  : public GpsFrame<GpsSynchroFrame>, public GenericObservable<GpsSynchro>
{
public:
  typedef GpsSynchroFrame frameType;
  typedef GenericObservable<GpsSynchro>::ObserverType ObserverType;
};

class GPS_FRAMES_API GpsPps
  : public GpsFrame<uint32_t>, public GenericObservable<GpsPps>
{
public:
  typedef uint32_t frameType;
  typedef GenericObservable<GpsPps>::ObserverType ObserverType;
};

class GpsFrames {
public:
  GpsGgaFrame ggaFrame;
  GpsGsaFrame gsaFrame;
  GpsGstFrame gstFrame;
  GpsGsvFrame gsvFrame;
  GpsHdtFrame hdtFrame;
  GpsRmcFrame rmcFrame;
  GpsRotFrame rotFrame;
  GpsVtgFrame vtgFrame;
  GpsZdaFrame zdaFrame;
  GpsSynchro  synchroFrame;
  GpsPps      ppsFrame;
};

} // pacpus

#endif
