/// @date created 2008/07/18 - 15:33
/// @author Gerald Dherbomez & Clement Fouque
/// @copyright Heudiasyc UMR UTC/CNRS 6599
/// @version $Id: $

#ifndef SEPTENTRIOCOMPONENT_H
#define SEPTENTRIOCOMPONENT_H

#include <string>
#include <QThread>
#include <QObject>
#include "SeptentrioSocket.h"
#include "kernel/ComponentBase.h"
#include "ui/polarxmainwindow.hpp"
// #include "polarxGPSTKsolver.hpp"

#include "structure/structure_septentrio.h"
#include "SerialCom/SerialCOM_Handle_Stream.hpp"
#include "SerialCom/SBF/SerialCOM_Protocol_SBF.hpp"
#include "SerialCom/SerialCOM_Msg.hpp"

#include "SerialCom/SBF/SerialCOM_Msg_MeasEpoch.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_ShortMeasEpoch.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GenMeasEpoch.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_EndOfMeas.hpp"

#include "SerialCom/SBF/SerialCOM_Msg_GPSNav.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GPSAlm.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GPSIon.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GPSUtc.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GPSRaw.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_CNAVRaw.hpp"

#include "SerialCom/SBF/SerialCOM_Msg_GEOMT00.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEOPRNMask.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEOFastCorr.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEOIntegrity.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEOFastCorrDegr.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEONav.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEODegrFactors.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEONetworkTime.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEOAlm.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEOIGPMask.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEOLongTermCorr.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEOIonoDelay.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEOServiceLevel.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEOClockEphCovMatrix.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEORaw.hpp"

#include "SerialCom/SBF/SerialCOM_Msg_PVTCartesian.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_PVTGeodetic.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_PosCovCartesian.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_PosCovGeodetic.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_VelCovCartesian.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_VelCovGeodetic.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_DOP.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_PVTResiduals.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_RAIMStatistics.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_GEOCorrections.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_BaseLine.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_EndOfPVT.hpp"

#include "SerialCom/SBF/SerialCOM_Msg_ReceiverTime.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_xPPSOffset.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_ExtEvent.hpp"

#include "SerialCom/SBF/SerialCOM_Msg_TrackingStatus.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_ReceiverStatus.hpp"
#include "SerialCom/SBF/SerialCOM_Msg_ReceiverSetup.hpp"

namespace pacpus {

class SeptentrioComponent
        : public QThread
        , public ComponentBase
{
    Q_OBJECT

public:
    SeptentrioComponent(QString name);
    ~SeptentrioComponent();

    virtual void stopActivity(); /*!< to stop the processing thread */
    virtual void startActivity(); /*!< to start the processing thread */
    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);


private:
    //! main loop of the thread
    void run();

    SeptentrioSocket * socketIf_;

    //! The Septentrio IP or hostname
    QString host_;

    //! The Septentrio port
    int port_;

    //! Requested Frame
    QString frame_ ;
    PolarxMainWindow * ui_ ;

    /*!\brief Object used to bufferize data and extract messages with the help of registered protocolhandle messages*/
    SerialCOM_Handle_Stream * pHandleStream;

    //! \brief Object to handle SBF data
    Plrx::SerialCOM_Protocol_SBF * pProtocolSBF ;

    /*! \brief time of arrival of the current data frame at the serial port */
    road_time_t currentRoadtime;
    road_time_t prevRoadTime;

    /*! \brief time uncertainty on the currentRoadtime */
    road_timerange_t currentTimerange;

    bool computeGPSTk ;
    //gpstk::Position curPos;
    //Vector<double> curVel ;
    //Vector<double> curTime ;
    //gpstk::Position recPos;
    // polarxGPSTKsolver * pSolver ;

    //! SharedMemory segment
    QSharedMemory * pShMem;

    //! Semaphore system pour la mise à jour de la memoire partagée.
    QSystemSemaphore * pShmSem ;

   template <typename T> void sendToShmem( short id , T * msg, road_time_t t, road_timerange_t tr );
};

} // namespace pacpus

#endif // SEPTENTRIOCOMPONENT_H
