/*********************************************************************
// created:    2005/10/17 - 15:09
// filename:   gpsServerSocket.cpp
//
// author:     Gerald Dherbomez
// 
// version:    $Id: gpsServerSocket.cpp 870 2010-07-23 09:50:45Z gdherbom $
//
// purpose:    Implementation of the gpsServerSocket class
*********************************************************************/


#include "network/GpsServerSocket.h"
#include "network/gpsServerSocketInterface.h"
#include <qsocket.h>
#include <qtextstream.h>
#include "kernel/pacpus.h"


GpsServerSocket::GpsServerSocket(int gpsServerSocketPort) : QServerSocket(gpsServerSocketPort)
{
  if (!ok())
    qWarning("Failed to  bind the port %d\n", gpsServerSocketPort); 
}


GpsServerSocket::~GpsServerSocket()
{
  socketDevice()->close(); 
}


void GpsServerSocket::customEvent(QCustomEvent* e)
{
  int i;
  switch(e->type() - QEvent::User) 
  {
  case SIGNAL_PPS:
    break; 

  case TRAME_GGA_DBL:
    ggaData = *(trame_gga_dbl*)(e->data());
    printf ("%d %d %d %d \n",ggaData.H, ggaData.Mi, ggaData.S, ggaData.Ms); 
    break;

  case TRAME_GSA:
    gsaData = *(trame_gsa*)(e->data());
    printf("GSA"); 
    break; 

  case TRAME_GST:
    gstData = *(trame_gst*)(e->data());
    break; 

  case TRAME_GSV:
    gsvData = *(trame_gsv*)(e->data());
    for (i=0 ; i<12 ; i++)
    printf ("%d ",gsvData.SatellitesInView[i][0]);
    printf ("\n");
    break; 

  case TRAME_HDT:
    hdtData = *(trame_hdt*)(e->data());
    break; 

  case TRAME_RMC:
    rmcData = *(trame_rmc*)(e->data());
    printf("RMC");
    break; 

  case TRAME_ROT:
    rotData = *(trame_rot*)(e->data());
    break; 

  case TRAME_VTG:
    vtgData = *(trame_vtg*)(e->data());
    printf("VTG"); 
    break; 

  case TRAME_ZDA:
    zdaData = *(trame_zda*)(e->data());
    printf("ZDA"); 
    break; 

  default:
    qDebug("Unknown GPS data received !\n"); 
  }
   
}


void GpsServerSocket::newConnection(int socket)
{
  GpsServerSocketInterface *s = new GpsServerSocketInterface(socket); 
}
