#ifndef DEF_WEBCAM_WORKER_HPP
#define DEF_WEBCAM_WORKER_HPP

// Includes, project.
#include <Pacpus/PacpusTools/AsyncWorkerBase.h>

// Includes, qt.
#include <QTimer>

// Includes, opencv.
#include <opencv/cxcore.h>
#include <opencv/highgui.h>

namespace pacpus
{
  class WebcamWorker
    : public pacpus::AsyncWorkerBase
  {
    Q_OBJECT
    public:
      /// Ctor of WebcamWorker.
      WebcamWorker();

      /// Dtor of WebcamWorker.
      virtual ~WebcamWorker();

      /// Open a webcam.
      void open(int device, int width, int height, int msec);

      /// Close the webcam.
      void close();

    public slots:
      /// Retrieve a frame from the webcam.
      void retrieveFrame();

    signals:
      /// Got a new frame.
      void gotFrame(cv::Mat frame);

    protected:
      /// Setup the worker.
      virtual void setup();

      /// Cleanup the worker.
      virtual void cleanup();

    private:
      QTimer* mHeartbeat;
      cv::VideoCapture mWebcam;
      cv::Mat mFrame;
  };
}

#endif
