#ifndef DEF_CVWEBCAM_COMPONENT_HPP
#define DEF_CVWEBCAM_COMPONENT_HPP

// Includes, project.
#include "WebcamWorker.hpp"

// Includes, qt.
#include <QObject>

// Includes, pacpus.
#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/DbiteFile.h>
#include <Pacpus/kernel/pacpus.h>
#include <Pacpus/PacpusTools/ShMem.h>

// Includes, opencv.
#include <opencv/cv.h>
#include <opencv/highgui.h>

#ifdef WIN32
#   ifdef CVWEBCAM_COMPONENT_EXPORTS
#       define CVWEBCAM_COMPONENT_API __declspec(dllexport)
#   else
#       define CVWEBCAM_COMPONENT_API __declspec(dllimport)
#   endif
#else
#   define CVWEBCAM_COMPONENT_API
#endif

namespace pacpus
{
  class CVWEBCAM_COMPONENT_API CVWebcamComponent
    : public QObject
    , public ComponentBase
  {
    Q_OBJECT
    public:
      /// Ctor of CVWebcamComponent.
      CVWebcamComponent(QString const& name);

	  /// Dtor of CVWebcamComponent
	  ~CVWebcamComponent();

      /// Stop the processing thread.
      virtual void stopActivity();

      /// Start the processing thread.
      virtual void startActivity();

      /// Configure the component.
      virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);

    public slots:
      /// Receive a new frame.
      void receiveFrame(cv::Mat frame);

    private:
      /// Display a frame.
      void displayFrame(cv::Mat const& frame);

      /// Save a frame.
      void saveFrame(cv::Mat const& frame);

      // Working thread, grabbing frame from a webcam.
      WebcamWorker mWebcam;

      // Webcam information 
      int mDevice;
      int mWidth;
      int mHeight;
      int mHasUI;
      int mFramerate;

      // Recording object.
      bool mIsRecording;
      DbiteFile mDBTFile;
      unsigned int mImageCounter;
      QString mFilenameTemplate;

	  // Shared memory segment
	  ShMem * mShMem;
	  bool firstTime;
  };
}

#endif
