/**
 *
 * Distributed under the UTC Heudiascy Pacpus License, Version 1.0.
 * Copyright (c) UTC Heudiasyc 2010 - 2013. All rights reserved.
 *
 * See the LICENSE file for more information or a copy at:
 *   http://www.hds.utc.fr/~kurdejma/LICENSE_1_0.txt
 *
 */

#ifndef DEF_PACPUS_DBTPLYFILEMANAGER_H
#define DEF_PACPUS_DBTPLYFILEMANAGER_H

#include <QThread>

#include <Pacpus/DbitePlayer/DbitePlayerConfig.h>
#include <Pacpus/DbitePlayer/DbtPlyEngine.h>
#include <Pacpus/kernel/road_time.h>
#include <Pacpus/kernel/ComponentBase.h>
#include <Pacpus/kernel/DbiteFile.h>

class QSemaphore;

namespace pacpus {

class DbtPlyEngine;

/// XML config properties:
///     dbt             PATH(S) path to DBT data file(s), separated by pipe symbol '|', relative to datadir property of DbtPlyEngine
///         e.g. dbt="gps/ublox.dbt|gps/ublox2.dbt"
///     ui              INT     graphical user interface (GUI) window number
///         e.g. ui="0"
///     verbose         INT     verbosity level
///         e.g. verbose="1"
/// @see DbtPlyEngine
class DBITE_PLAYER_API DbtPlyFileManager
        : public QThread
        , public ComponentBase
{
    Q_OBJECT

public:
    /// constructor
    DbtPlyFileManager(QString name);
    /// destructor
    virtual ~DbtPlyFileManager();

    /// the player replays only the last data that has not been yet replayed
    /// @todo Rename
    void playMode1 (road_time_t tDbt, bool reverse);
    /// the player replays all the data that have not been yet replayed
    /// @todo Rename
    void playMode2 (road_time_t tDbt, bool reverse);

    /// virtual method: call when new DBT data are replayed
    virtual void processData(road_time_t time, road_timerange_t timeRange, void * data) = 0;
    virtual void displayUI();

    /// 3 Virtual methods relative to the ComponentBase inheritance
    virtual COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
    /// @todo Documentation
    virtual void startActivity();
    /// @todo Documentation
    virtual void stopActivity();

    /// The loop of the thread
    virtual void run();

public Q_SLOTS:
    /// slot activated by the engine when it computes new DBT time
    void  playData(road_time_t tDbt,road_time_t tNow, bool reverse);

    /// put the file descriptor to the beginning of the file
    void beginfile();

Q_SIGNALS:
    /// signal sent to the engine to provide to it the tmin and tmax of the file
    void tMinMaxIs(road_time_t tmin, road_time_t tmax);

protected:
    /// Verbosity level
    int mVerbose;

    /// a pointer on the player engine
    DbtPlyEngine * mEngine;

    /// the absolute path of the DBT file
    QString dbtProperty_;
    QStringList mDbtFilenameList;

    /// The directory where the DBT file is located
    QString mDbtDataPath;

    /// Display or not the graphical interface
    bool mShowGui;

    /// @todo Documentation
    struct dbtStruct
    {
        char * buffer;
        road_time_t t;
        road_timerange_t tr;
    };

    /// @todo Documentation
    struct dbtStructFile
    {
        // the DBT file descriptor
        pacpus::DbiteFile * pfile;
        // the buffer where the data are stored after the reading and the associated time, timerange and file descriptor
        dbtStruct cur;
        // the previous DBT data, these ones that must be processed
        dbtStruct toProcess;
    };

    QList<dbtStructFile> dbt_;
    int dbtIndex_;

private:
    /// @todo Documentation
    bool processDbtFileHdfile(dbtStructFile & dbtFile, pacpus::DbiteFile::ReadDirection direction);

private:
    // reading backward?
    bool reverse_;

    /// the estimated DBT time sent by the engine and computed relatively to the state of the player
    road_time_t timeToRead_;

    /// The mode of replay
    /// @see playMode1, playMode2 methods
    int mode_;

    /// The minimum and maximum time of the data contained in the file
    road_time_t tMin_, tMax_;

    /// the synchronization semaphore with the engine
    QSemaphore * sync_;

    /// For statistics purpose - delta time between the instant when the tDbt is computed and the instant when it is
    /// taken into account by the file manager
    int deltaTDbtTab_[1000];
    int deltaTDbtTabLoop_;
};

} // namespace pacpus

#endif // DEF_PACPUS_DBTPLYFILEMANAGER_H
