// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// 
/// @author  Firstname Surname <firstname.surname@utc.fr>
/// @date    Month, Year
/// @version $Id$
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Detailed description.

#ifndef DEF_PACPUS_H
#define DEF_PACPUS_H

#include <Pacpus/kernel/road_time.h>

// Deprecated, you should use M_PI from cmath.
#ifndef PACPUS_PI
#   define PACPUS_PI       3.1415926
#endif

// Export macro for PacpusLib DLL for Windows only
#ifdef WIN32
#   ifdef PACPUSLIB_EXPORTS
//  make DLL
#       define PACPUSLIB_API __declspec(dllexport)
#   else
//      use DLL
#       define PACPUSLIB_API __declspec(dllimport)
#   endif
#else
//  On other platforms, simply ignore this
#   define PACPUSLIB_API
#endif

#ifdef __GNUC__
#   define PACPUS_DEPRECATED(func)              func __attribute__ ((deprecated))
#   define PACPUS_DEPRECATED_MSG(func, msg)     PACPUS_DEPRECATED(func)
#elif defined(_MSC_VER)
#   define PACPUS_DEPRECATED(func)              __declspec(deprecated) func
#   define PACPUS_DEPRECATED_MSG(func, msg)     __declspec(deprecated("was declared deprecated: " msg)) func
#else
#   pragma message("WARNING: You need to implement PACPUS_DEPRECATED for this compiler")
#   define PACPUS_DEPRECATED(func)              func
#   define PACPUS_DEPRECATED_MSG(func, msg)     func
#endif

#endif // DEF_PACPUS_H
