// This file is part of the PACPUS framework distributed under the
// CECILL-C License, Version 1.0.
// 
/// @author  Gerald Dherbomez <firstname.surname@utc.fr>
/// @date    January, 2006
/// @version $Id: XmlConfigFile.h 64 2013-01-09 16:41:12Z kurdejma $
/// @copyright Copyright (c) UTC/CNRS Heudiasyc 2006 - 2013. All rights reserved.
/// @brief Brief description.
///
/// Purpose:    Classe permettant d'enregistrer un fichier de 
///             configuration XML
///             Le fichier XML contient 2 sections : 
///             - parameters : contient les parametres de l'application 
///             - components : contient les composants
///             les composants ne peuvent pas avoir de noeuds fils
///
/// @todo       Creer une dtd qui permet de definir la liste des classes possibles
///             que peuvent prendre les composants 

#ifndef DEF_PACPUS_XMLCONFIGFILE_H
#define DEF_PACPUS_XMLCONFIGFILE_H

#include <Pacpus/kernel/pacpus.h>
#include <Pacpus/kernel/XmlComponentConfig.h>

#include <QDomElement>
#include <QMutex>
#include <QStringList>

class QFile;

namespace pacpus {

/// XML config properties:
///     list            STRING(S)   name(s) of plugin files to be loaded, separated by pipe symbol '|'
///         e.g. dbt="libDbtPlyGps.so|libDbtPlyVision.so
class PACPUSLIB_API XmlConfigFile
{
    friend XmlComponentConfig::XmlComponentConfig(const QString&);
    friend class ComponentManager;

public:
    /// @todo Documentation
    static XmlConfigFile * create();
    /// @todo Documentation
    static void destroy();
    /// @todo Documentation
    QDomElement getComponent(QString name);
    /// @returns a list of all names of components declared in the XML tree
    QStringList getAllComponents();
    /// @todo Documentation
    QStringList getAllPlugins();
    /// @todo Documentation
    int loadFile(QString fileName);

    /// @todo Documentation
    /// not used
    void saveFile(QString fileName);
    /// @todo Documentation
    /// not used
    void addComponent(QDomElement component);
    /// @todo Documentation
    /// not used
    void delComponent(QDomElement component);

protected:
private:
    XmlConfigFile();
    ~XmlConfigFile();

    static XmlConfigFile * _xmlConfigFile;
    
    QDomElement createComponent(QString name);

private:
    QDomDocument _document;
    QFile * _file;
    QMutex _mutex;

    int _numberOfComponents;
};

} // namespace pacpus

#endif // DEF_PACPUS_XMLCONFIGFILE_H
