// *********************************************************************
//  created:    2007/11/13 - 16:51
//  filename:   DbtPlyAlascaManager.h
//
//  author:     Gerald Dherbomez
//              Copyright Heudiasyc UMR UTC/CNRS 6599
// 
//  version:    $Id: $
//
//  purpose:    
// *********************************************************************

#ifndef DBTPLYALASCAMANAGER_H
#define DBTPLYALASCAMANAGER_H

#include <fstream>

#include "DbitePlayer/DbtPlyFileManager.h"
#include "structure/structure_telemetre.h"

// Export macro for DbtPlyAlasca DLL for Windows only
#ifdef WIN32
#   ifdef DBTPLYALASCA_EXPORTS
        // make DLL
#       define DBTPLYALASCA_API __declspec(dllexport)
#   else
        // use DLL
#       define DBTPLYALASCA_API __declspec(dllimport)
#   endif
#else
    // On other platforms, simply ignore this 
#   define DBTPLYALASCA_API 
#endif

namespace pacpus {
    
class ShMem;

class DBTPLYALASCA_API DbtPlyAlascaManager
        : public DbtPlyFileManager
{
public:
    DbtPlyAlascaManager(QString name);
    ~DbtPlyAlascaManager();

protected:
    void processData(road_time_t t, road_timerange_t tr, void * buffer);
    void displayUI();

    virtual ComponentBase::COMPONENT_CONFIGURATION configureComponent(XmlComponentConfig config);
    virtual void startActivity();
    virtual void stopActivity();

private:
    ShMem * mShMem;
    ScanAlascaData mAlascaData;

    std::ifstream mDataFile;
    QString mDataFilename;
};

} // namespace pacpus

#endif // DBTPLYALASCAMANAGER_H
